/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.network;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.FBTypePaletteViewerProvider;
import org.eclipse.fordiac.ide.application.utilities.FbTypeTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.network.CFBNetworkcontextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.network.editparts.CompositeNetworkEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class CompositeNetworkEditor
extends FBNetworkEditor
implements IFBTEditorPart {
    private CompositeFBType fbType;
    private CommandStack commandStack;
    private TypeLibrary typeLib;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 8 && (notification.getNewValue() == null && notification.getNewValue() != notification.getOldValue() || notification.getNewValue() != null && !notification.getNewValue().equals(notification.getOldValue()))) {
                super.notifyChanged(notification);
            }
        }
    };

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected CompositeNetworkEditPartFactory getEditPartFactory() {
        return new CompositeNetworkEditPartFactory((GraphicalEditor)this);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void dispose() {
        this.getModel().eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, (ActionRegistry)this.getActionRegistry(), (FBType)this.fbType);
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        EditPart editPart = this.getEditPartForSelection(selectedElement);
        if (editPart != null) {
            this.getGraphicalViewer().select(editPart);
            return true;
        }
        return selectedElement instanceof FBNetwork;
    }

    EditPart getEditPartForSelection(Object selectedElement) {
        Map map = this.getGraphicalViewer().getEditPartRegistry();
        for (Object key : map.keySet()) {
            if ((!(key instanceof FB) || (FB)key != selectedElement) && (!(key instanceof Connection) || (Connection)key != selectedElement)) continue;
            selectedElement = key;
            break;
        }
        Object obj = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        if (obj instanceof EditPart) {
            return (EditPart)obj;
        }
        return null;
    }

    protected Palette getPalette() {
        return this.typeLib.getBlockTypeLib();
    }

    public AutomationSystem getSystem() {
        return null;
    }

    protected void setModel(IEditorInput input) {
        FBTypeEditorInput untypedInput;
        if (input instanceof FBTypeEditorInput && (untypedInput = (FBTypeEditorInput)input).getContent() instanceof CompositeFBType) {
            this.fbType = (CompositeFBType)untypedInput.getContent();
            this.setModel(this.fbType.getFBNetwork());
            this.getModel().eAdapters().add((Object)this.adapter);
            this.configurePalette(untypedInput);
        }
        this.setTitleImage(FordiacImage.ICON_FB_NETWORK.getImage());
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
    }

    protected void setEditorPartName(IEditorInput input) {
        this.setPartName(FordiacMessages.FBNetwork);
    }

    protected void configurePalette(FBTypeEditorInput fbTypeEditorInput) {
        this.typeLib = fbTypeEditorInput.getPaletteEntry().getTypeLibrary();
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new FBTypePaletteViewerProvider(this.fbType.getPaletteEntry().getFile().getProject(), (EditDomain)this.getEditDomain(), this.getPaletteNavigatorID());
    }

    protected String getPaletteNavigatorID() {
        return "org.eclipse.fordiac.ide.compositefbpaletteviewer";
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new CFBNetworkcontextMenuProvider((DiagramEditorWithFlyoutPalette)this, this.getActionRegistry(), zoomManager, this.typeLib);
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new FbTypeTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.fbType.getPaletteEntry().getFile().getProject());
    }

    public void gotoMarker(IMarker marker) {
        try {
            FBNetworkElement fbne;
            Object location;
            Map attributes = marker.getAttributes();
            if (FordiacMarkerHelper.markerTargetsFBNetworkElement((Map)attributes) && (location = attributes.get("location")) instanceof String && (fbne = this.getModel().getElementNamed((String)location)) != null) {
                this.selectElement(fbne);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Could not get marker attributes", (Exception)((Object)e));
        }
    }

    public boolean isMarkerTarget(IMarker marker) {
        try {
            return FordiacMarkerHelper.markerTargetsFBNetworkElement((Map)marker.getAttributes());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Could not get marker attributes", (Exception)((Object)e));
            return false;
        }
    }

    public void reloadType(FBType type) {
        if (type instanceof CompositeFBType) {
            FBNetwork fbNetwork = ((CompositeFBType)type).getFBNetwork();
            if (fbNetwork != null) {
                this.getGraphicalViewer().setContents((Object)fbNetwork);
            } else {
                EditorUtils.CloseEditor.run((IEditorPart)this);
            }
        }
    }
}

