/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.editors.I4diacModelEditor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteFBNetworkElementCommand
extends Command {
    private FBNetwork fbParent;
    private final FBNetworkElement element;
    private final CompoundCommand cmds = new CompoundCommand();
    private ErrorMarkerBuilder errorMarker;
    private final List<ErrorMarkerBuilder> valueErrorMarkers = new ArrayList<ErrorMarkerBuilder>();

    public DeleteFBNetworkElementCommand(FBNetworkElement element) {
        super(Messages.DeleteFBNetworkElementCommand_DeleteFBOrSubapplication);
        this.element = element;
    }

    public FBNetworkElement getFBNetworkElement() {
        return this.element;
    }

    public boolean canExecute() {
        if (this.element instanceof FB && ((FB)this.element).isResourceTypeFB()) {
            return false;
        }
        return this.element != null && this.element.getFbNetwork() != null;
    }

    public void execute() {
        if (this.element instanceof ErrorMarkerRef) {
            this.errorMarker = FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)((ErrorMarkerRef)this.element));
        }
        this.fbParent = this.element.getFbNetwork();
        if (this.element.isMapped()) {
            this.cmds.add((Command)new UnmapCommand(this.element));
        }
        this.getDeleteConnections(this.element);
        this.handleValueErrorMarkers();
        if (this.cmds.canExecute()) {
            this.cmds.execute();
        }
        this.fbParent.getNetworkElements().remove((Object)this.element);
        if (this.element instanceof SubApp) {
            DeleteFBNetworkElementCommand.closeSubApplicationEditor((SubApp)this.element);
        }
    }

    public void undo() {
        this.fbParent.getNetworkElements().add((Object)this.element);
        if (this.cmds.canUndo()) {
            this.cmds.undo();
        }
        if (this.element instanceof ErrorMarkerRef && this.errorMarker != null) {
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)this.errorMarker);
        }
        this.restoreValueErrorMarkers();
    }

    public void redo() {
        if (this.cmds.canRedo()) {
            this.cmds.redo();
        }
        this.handleValueErrorMarkers();
        if (this.element instanceof ErrorMarkerRef) {
            this.errorMarker = FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)((ErrorMarkerRef)this.element));
        }
        this.fbParent.getNetworkElements().remove((Object)this.element);
    }

    private void getDeleteConnections(FBNetworkElement element) {
        for (IInterfaceElement intElement : element.getInterface().getAllInterfaceElements()) {
            EList connList = null;
            connList = intElement.isIsInput() ? intElement.getInputConnections() : intElement.getOutputConnections();
            if (connList == null) continue;
            connList.forEach(con -> this.cmds.add((Command)new DeleteConnectionCommand((Connection)con)));
        }
    }

    private static void closeSubApplicationEditor(SubApp subapp) {
        EditorUtils.closeEditorsFiltered(editor -> editor instanceof I4diacModelEditor && subapp.getSubAppNetwork() == ((I4diacModelEditor)editor).getModel());
    }

    private void handleValueErrorMarkers() {
        for (VarDeclaration varIn : this.element.getInterface().getInputVars()) {
            if (varIn.getValue() == null || !varIn.getValue().hasError()) continue;
            this.valueErrorMarkers.add(FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)varIn.getValue()));
        }
    }

    private void restoreValueErrorMarkers() {
        for (ErrorMarkerBuilder errorMarkerBuilder : this.valueErrorMarkers) {
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)errorMarkerBuilder);
        }
        this.valueErrorMarkers.clear();
    }
}

