/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public class DeleteErrorMarkerCommand
extends Command {
    private final DeleteInterfaceCommand deleteErrorMarkerIECmd;
    private final DeleteFBNetworkElementCommand deleteErrorMarkerFBN;

    public DeleteErrorMarkerCommand(ErrorMarkerInterface errorIe) {
        this.deleteErrorMarkerIECmd = new DeleteInterfaceCommand((IInterfaceElement)errorIe);
        this.deleteErrorMarkerFBN = DeleteErrorMarkerCommand.createDeleteFBNCommand(errorIe);
    }

    public void execute() {
        this.performDeletion();
    }

    private void performDeletion() {
        this.deleteErrorMarkerIECmd.execute();
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.execute();
        }
    }

    public void undo() {
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.undo();
        }
        this.deleteErrorMarkerIECmd.undo();
    }

    public void redo() {
        this.deleteErrorMarkerIECmd.redo();
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.redo();
        }
    }

    private static DeleteFBNetworkElementCommand createDeleteFBNCommand(ErrorMarkerInterface errorIe) {
        if (errorIe.getFBNetworkElement() instanceof ErrorMarkerFBNElement && errorIe.getFBNetworkElement().getInterface().getErrorMarker().size() == 1) {
            return new DeleteFBNetworkElementCommand(errorIe.getFBNetworkElement());
        }
        return null;
    }
}

