/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.commands.Command;

public class CreateInternalFBCommand
extends Command
implements CreationCommand {
    private final BaseFBType baseFbType;
    private PaletteEntry fbType;
    private final String name;
    private final int index;
    private FB internalFB;
    static final String DEFAULT_INTERNAL_FB_NAME = "InternalFB1";

    protected CreateInternalFBCommand(BaseFBType baseFbType) {
        this(baseFbType, 0, null, null);
    }

    public CreateInternalFBCommand(BaseFBType baseFbType, int index, String name, PaletteEntry fbType) {
        this.baseFbType = baseFbType;
        this.fbType = fbType;
        if (fbType == null) {
            EMap typeLib = baseFbType.getTypeLibrary().getBlockTypeLib().getFbTypes();
            this.fbType = (PaletteEntry)((Map.Entry)typeLib.get(0)).getValue();
        }
        this.name = name != null ? name : DEFAULT_INTERNAL_FB_NAME;
        this.index = index;
    }

    public CreateInternalFBCommand(BaseFBType baseFbType, int index, String name, PaletteEntry fbType, Palette palette) {
        this.baseFbType = baseFbType;
        this.fbType = fbType;
        if (fbType == null) {
            this.fbType = (PaletteEntry)palette.eContents().get(0);
        }
        this.name = name != null ? name : DEFAULT_INTERNAL_FB_NAME;
        this.index = index;
    }

    public Object getCreatedElement() {
        return this.internalFB;
    }

    private EList<FB> getInteralFBList() {
        BaseFBType type = this.baseFbType;
        return type.getInternalFbs();
    }

    public void execute() {
        this.internalFB = LibraryElementFactory.eINSTANCE.createFB();
        this.internalFB.setPaletteEntry(this.fbType);
        this.internalFB.setComment("");
        this.redo();
        this.internalFB.setName(NameRepository.createUniqueName((INamedElement)this.internalFB, (String)this.name));
    }

    public void undo() {
        this.getInteralFBList().remove((Object)this.internalFB);
    }

    public void redo() {
        this.getInteralFBList().add(this.index, (Object)this.internalFB);
    }
}

