/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.gef.commands.Command;

public abstract class AbstractCreateFBNetworkElementCommand
extends Command {
    private final FBNetworkElement element;
    private final FBNetwork fbNetwork;
    private int x;
    private int y;

    protected AbstractCreateFBNetworkElementCommand(FBNetwork fbNetwork, FBNetworkElement element, int x, int y) {
        this.fbNetwork = fbNetwork;
        this.element = element;
        this.x = x;
        this.y = y;
    }

    public boolean canExecute() {
        if (FBNetworkHelper.isTypeInsertionSave((FBType)this.element.getType(), (EObject)this.fbNetwork)) {
            return this.fbNetwork != null;
        }
        return false;
    }

    public void execute() {
        this.element.setInterface(this.getTypeInterfaceList().copy());
        this.element.updatePosition(this.x, this.y);
        this.fbNetwork.getNetworkElements().add((Object)this.element);
        this.element.setName(NameRepository.createUniqueName((INamedElement)this.element, (String)this.getInitalInstanceName()));
    }

    public void redo() {
        this.fbNetwork.getNetworkElements().add((Object)this.element);
    }

    public void undo() {
        this.fbNetwork.getNetworkElements().remove((Object)this.element);
    }

    public void updateCreatePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public FBNetworkElement getElement() {
        return this.element;
    }

    protected String getInitalInstanceName() {
        return this.element.getTypeName();
    }

    protected abstract InterfaceList getTypeInterfaceList();

    protected FBNetwork getFBNetwork() {
        return this.fbNetwork;
    }
}

