/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.gef.commands.Command;

public class ChangeAlgorithmOrderCommand
extends Command {
    private final Algorithm alg;
    private final EList<Algorithm> type;
    private final int oldIndex;
    private int newIndex;

    public ChangeAlgorithmOrderCommand(EList<Algorithm> type, Algorithm alg, int indexChanged) {
        this.type = type;
        this.alg = alg;
        this.oldIndex = type.indexOf((Object)alg);
        if (indexChanged == 1) {
            this.newIndex = this.oldIndex + 1;
        } else if (indexChanged == -1) {
            this.newIndex = this.oldIndex - 1;
        }
        if (this.newIndex < 0) {
            this.newIndex = 0;
        }
        if (this.newIndex >= type.size()) {
            this.newIndex = type.size() - 1;
        }
    }

    public ChangeAlgorithmOrderCommand(EList<Algorithm> type, Algorithm alg, boolean moveUp) {
        this(type, alg, moveUp ? -1 : 1);
    }

    public boolean canExecute() {
        return this.alg != null && this.type.size() > 1 && this.type.size() > this.newIndex;
    }

    public void execute() {
        this.moveTo(this.newIndex);
    }

    public void redo() {
        this.moveTo(this.newIndex);
    }

    public void undo() {
        this.moveTo(this.oldIndex);
    }

    private void moveTo(int index) {
        this.type.move(index, (Object)this.alg);
    }
}

