/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.change.AbstractReconnectConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectAdapterConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectDataConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectEventConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.dataimport.ConnectionHelper;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractUpdateFBNElementCommand
extends Command {
    protected final CompoundCommand reconnCmds = new CompoundCommand();
    protected final CompoundCommand resourceConnCreateCmds = new CompoundCommand();
    protected MapToCommand mapCmd = null;
    protected UnmapCommand unmapCmd = null;
    protected FBNetworkElement newElement;
    protected FBNetworkElement oldElement;
    protected FBNetwork network;
    protected final List<ErrorMarkerBuilder> errorPins;
    protected ErrorMarkerBuilder errorMarkerBuilder;
    protected PaletteEntry entry;

    protected AbstractUpdateFBNElementCommand(FBNetworkElement oldElement) {
        this.oldElement = oldElement;
        this.network = this.oldElement.getFbNetwork();
        this.errorPins = new ArrayList<ErrorMarkerBuilder>();
    }

    public void execute() {
        Resource resource = null;
        List<ConnData> resourceConns = null;
        if (this.oldElement.isMapped()) {
            if (this.network.equals(this.oldElement.getResource().getFBNetwork())) {
                this.oldElement = this.oldElement.getOpposite();
                this.network = this.oldElement.getFbNetwork();
            }
            resource = this.oldElement.getResource();
            resourceConns = this.getResourceCons();
            this.unmapCmd = new UnmapCommand(this.oldElement);
            this.unmapCmd.execute();
        }
        this.createNewFB();
        this.network.getNetworkElements().add((Object)this.newElement);
        this.handleErrorMarker();
        this.handleApplicationConnections();
        this.network.getNetworkElements().remove((Object)this.oldElement);
        this.newElement.setName(this.oldElement.getName());
        if (resource != null) {
            this.mapCmd = new MapToCommand(this.newElement, resource);
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
                this.recreateResourceConns(resourceConns);
            }
        }
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        this.network.getNetworkElements().add((Object)this.newElement);
        this.reconnCmds.redo();
        this.network.getNetworkElements().remove((Object)this.oldElement);
        this.errorPins.forEach(FordiacMarkerHelper::createMarkerInFile);
        if (this.errorMarkerBuilder != null && this.newElement instanceof ErrorMarkerRef) {
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)this.errorMarkerBuilder);
        }
        if (this.mapCmd != null) {
            this.mapCmd.redo();
            this.resourceConnCreateCmds.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.resourceConnCreateCmds.undo();
            this.mapCmd.undo();
        }
        this.errorPins.stream().map(ErrorMarkerBuilder::getErrorMarkerRef).forEach(FordiacMarkerHelper::deleteErrorMarker);
        if (this.errorMarkerBuilder != null && this.newElement instanceof ErrorMarkerRef) {
            FordiacMarkerHelper.deleteErrorMarker((ErrorMarkerRef)((ErrorMarkerRef)this.newElement));
        }
        this.network.getNetworkElements().add((Object)this.oldElement);
        this.reconnCmds.undo();
        this.network.getNetworkElements().remove((Object)this.newElement);
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    protected void recreateResourceConns(List<ConnData> resourceConns) {
        FBNetworkElement orgMappedElement = this.unmapCmd.getMappedFBNetworkElement();
        FBNetworkElement copiedMappedElement = this.newElement.getOpposite();
        for (ConnData connData : resourceConns) {
            IInterfaceElement source = this.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.source);
            IInterfaceElement dest = this.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.dest);
            if (source == null || dest == null) continue;
            AbstractConnectionCreateCommand dccc = AbstractUpdateFBNElementCommand.createConnCreateCMD(source, copiedMappedElement.getFbNetwork());
            dccc.setSource(source);
            dccc.setDestination(dest);
            if (!dccc.canExecute()) continue;
            dccc.execute();
            this.resourceConnCreateCmds.add((Command)dccc);
        }
    }

    protected IInterfaceElement findUpdatedInterfaceElement(FBNetworkElement newElement, FBNetworkElement oldElement, IInterfaceElement oldInterface) {
        if (oldInterface != null && oldInterface.getFBNetworkElement() == oldElement) {
            IInterfaceElement interfaceElement = this.updateSelectedInterface(oldInterface, newElement);
            if (!oldInterface.getType().isCompatibleWith(interfaceElement.getType())) {
                return this.createWrongTypeMarker(oldInterface, interfaceElement, newElement);
            }
            return interfaceElement;
        }
        return oldInterface;
    }

    private boolean isInDeleteConnList(Connection conn) {
        for (Object cmd : this.reconnCmds.getCommands()) {
            if (!(cmd instanceof DeleteConnectionCommand) || !((DeleteConnectionCommand)((Object)cmd)).getConnectionView().equals(conn)) continue;
            return true;
        }
        return false;
    }

    protected static List<Connection> getAllConnections(FBNetworkElement element) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (IInterfaceElement ifEle : element.getInterface().getAllInterfaceElements()) {
            if (ifEle.isIsInput()) {
                connections.addAll((Collection<Connection>)ifEle.getInputConnections());
                continue;
            }
            connections.addAll((Collection<Connection>)ifEle.getOutputConnections());
        }
        return connections;
    }

    protected void createValues() {
        for (VarDeclaration inVar : this.newElement.getInterface().getInputVars()) {
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            this.checkSourceParam(inVar);
        }
    }

    private void checkSourceParam(VarDeclaration variable) {
        VarDeclaration srcVar = this.oldElement.getInterface().getVariable(variable.getName());
        if (srcVar != null && srcVar.getValue() != null) {
            variable.getValue().setValue(srcVar.getValue().getValue());
        }
    }

    protected List<ConnData> getResourceCons() {
        ArrayList<ConnData> retVal = new ArrayList<ConnData>();
        FBNetworkElement resElement = this.oldElement.getOpposite();
        for (Connection conn : AbstractUpdateFBNElementCommand.getAllConnections(resElement)) {
            IInterfaceElement source = conn.getSource();
            IInterfaceElement dest = conn.getDestination();
            if (!source.getFBNetworkElement().isMapped() || !dest.getFBNetworkElement().isMapped()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
                continue;
            }
            if ((source.getFBNetworkElement() != resElement || dest.getFBNetworkElement().getOpposite().getFbNetwork() == this.oldElement.getFbNetwork()) && (dest.getFBNetworkElement() != resElement || source.getFBNetworkElement().getOpposite().getFbNetwork() == this.oldElement.getFbNetwork())) continue;
            retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
        }
        return retVal;
    }

    private void handleErrorMarker() {
        if (!(this.oldElement instanceof ErrorMarkerFBNElement) && this.newElement instanceof ErrorMarkerFBNElement) {
            String errorMessage = MessageFormat.format("Type File: {0} could not be loaded for FB", this.entry.getFile() != null ? this.entry.getFile().getFullPath() : "null type");
            this.errorMarkerBuilder = FordiacMarkerHelper.createErrorMarker((String)errorMessage, (INamedElement)this.newElement, (int)0);
            this.errorMarkerBuilder.setErrorMarkerRef((ErrorMarkerRef)this.newElement);
            ((ErrorMarkerRef)this.newElement).setErrorMessage(errorMessage);
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)this.errorMarkerBuilder);
            this.moveEntryToErrorLib();
        }
        if (this.oldElement instanceof ErrorMarkerFBNElement && this.newElement instanceof ErrorMarkerFBNElement) {
            this.copyErrorMarkerRef();
        }
    }

    private void copyErrorMarkerRef() {
        long id = ((ErrorMarkerFBNElement)this.oldElement).getFileMarkerId();
        String errorMessage = ((ErrorMarkerFBNElement)this.oldElement).getErrorMessage();
        FBNetworkElement repairedElement = ((ErrorMarkerFBNElement)this.oldElement).getRepairedElement();
        ((ErrorMarkerFBNElement)this.newElement).setFileMarkerId(id);
        ((ErrorMarkerFBNElement)this.newElement).setErrorMessage(errorMessage);
        if (repairedElement != null) {
            ((ErrorMarkerFBNElement)this.newElement).setRepairedElement(repairedElement);
        }
    }

    private void moveEntryToErrorLib() {
        TypeLibrary typeLibrary = this.oldElement.getTypeLibrary();
        typeLibrary.removePaletteEntry(this.entry);
        typeLibrary.getErrorTypeLib().addPaletteEntry(this.entry);
    }

    private IInterfaceElement createErrorMarker(FBNetworkElement newElement, IInterfaceElement oldInterface, String errorMessage) {
        boolean markerExists = newElement.getInterface().getErrorMarker().stream().anyMatch(e -> e.getName().equals(oldInterface.getName()) && e.isIsInput() == oldInterface.isIsInput());
        ErrorMarkerInterface interfaceElement = ConnectionHelper.createErrorMarkerInterface((DataType)oldInterface.getType(), (String)oldInterface.getName(), (boolean)oldInterface.isIsInput(), (InterfaceList)newElement.getInterface());
        if (!markerExists) {
            ErrorMarkerBuilder createErrorMarker = FordiacMarkerHelper.createErrorMarker((String)errorMessage, (INamedElement)newElement, (int)0);
            createErrorMarker.setErrorMarkerRef((ErrorMarkerRef)interfaceElement);
            FordiacMarkerHelper.createMarkerInFile((ErrorMarkerBuilder)createErrorMarker);
            this.errorPins.add(createErrorMarker);
        }
        return interfaceElement;
    }

    private ErrorMarkerInterface createWrongTypeMarker(IInterfaceElement oldInterface, IInterfaceElement newInterface, FBNetworkElement element) {
        String errorMessage = MessageFormat.format(Messages.UpdateFBTypeCommand_type_mismatch, oldInterface.getTypeName(), newInterface.getTypeName());
        ErrorMarkerInterface createErrorMarker = (ErrorMarkerInterface)this.createErrorMarker(element, oldInterface, errorMessage);
        createErrorMarker.setErrorMessage(Messages.UpdateFBTypeCommand_wrong_type);
        return createErrorMarker;
    }

    private ErrorMarkerInterface creatMissingMarker(IInterfaceElement oldInterface, FBNetworkElement element) {
        return (ErrorMarkerInterface)this.createErrorMarker(element, oldInterface, MessageFormat.format(Messages.UpdateFBTypeCommand_Pin_not_found, oldInterface.getName()));
    }

    private IInterfaceElement updateSelectedInterface(IInterfaceElement oldInterface, FBNetworkElement newElement) {
        IInterfaceElement updatedSelected = newElement.getInterfaceElement(oldInterface.getName());
        if (updatedSelected == null) {
            updatedSelected = this.creatMissingMarker(oldInterface, newElement);
        }
        return updatedSelected;
    }

    protected void handleApplicationConnections() {
        for (Connection connection : AbstractUpdateFBNElementCommand.getAllConnections(this.oldElement)) {
            IInterfaceElement onOtherFB;
            IInterfaceElement onSelectedFB;
            if (connection.getSourceElement() == this.oldElement) {
                onSelectedFB = connection.getSource();
                onOtherFB = connection.getDestination();
            } else {
                onSelectedFB = connection.getDestination();
                onOtherFB = connection.getSource();
            }
            if (onSelectedFB == null || onOtherFB == null) continue;
            IInterfaceElement updatedSelected = this.updateSelectedInterface(onSelectedFB, this.newElement);
            IInterfaceElement updatedOther = onSelectedFB.getFBNetworkElement() == onOtherFB.getFBNetworkElement() ? this.updateSelectedInterface(onOtherFB, this.newElement) : onOtherFB.getFBNetworkElement().getInterfaceElement(onOtherFB.getName());
            this.handleReconnect(connection, onSelectedFB, onOtherFB, updatedSelected, updatedOther);
        }
    }

    private void handleReconnect(Connection connection, IInterfaceElement selected, IInterfaceElement other, IInterfaceElement updatedSelected, IInterfaceElement updatedOther) {
        if (!updatedSelected.getType().isCompatibleWith(updatedOther.getType())) {
            if (other instanceof ErrorMarkerInterface && other.getType().isCompatibleWith(updatedSelected.getType())) {
                updatedOther = other;
            } else {
                updatedSelected = this.createWrongTypeMarker(selected, updatedSelected, this.newElement);
            }
        }
        if (selected.isIsInput() != updatedSelected.isIsInput()) {
            updatedSelected = this.creatMissingMarker(selected, this.newElement);
        }
        if (other.isIsInput() != updatedOther.isIsInput()) {
            updatedOther = other;
        }
        if (updatedOther instanceof ErrorMarkerInterface) {
            ((ErrorMarkerInterface)updatedOther).setRepairedEndpoint(updatedSelected);
        }
        if (updatedSelected instanceof ErrorMarkerInterface) {
            ((ErrorMarkerInterface)updatedSelected).setRepairedEndpoint(updatedOther);
        }
        if (updatedOther instanceof ErrorMarkerInterface && updatedOther.getFBNetworkElement() != updatedSelected.getFBNetworkElement()) {
            this.reconnectConnection(connection, updatedSelected, connection.getSourceElement() == this.oldElement, connection.getFBNetwork());
        } else if (connection.getSourceElement() == this.oldElement) {
            this.replaceConnection(connection, updatedSelected, updatedOther);
        } else {
            this.replaceConnection(connection, updatedOther, updatedSelected);
        }
    }

    protected void replaceConnection(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        if (!this.isInDeleteConnList(oldConn)) {
            FBNetwork fbn = oldConn.getFBNetwork();
            DeleteConnectionCommand cmd = new DeleteConnectionCommand(oldConn);
            cmd.execute();
            this.reconnCmds.add((Command)cmd);
            if (source != null && dest != null) {
                AbstractConnectionCreateCommand dccc = AbstractUpdateFBNElementCommand.createConnCreateCMD(source, fbn);
                dccc.setSource(source);
                dccc.setDestination(dest);
                dccc.setArrangementConstraints(oldConn.getRoutingData());
                if (dccc.canExecute()) {
                    dccc.execute();
                    this.reconnCmds.add((Command)dccc);
                }
            }
        }
    }

    protected void reconnectConnection(Connection oldConn, IInterfaceElement selected, boolean isSourceReconnect, FBNetwork fbn) {
        AbstractReconnectConnectionCommand reconnConnCmd = this.createReconnCMD(oldConn, selected, isSourceReconnect, fbn);
        if (reconnConnCmd.canExecute()) {
            reconnConnCmd.execute();
            this.reconnCmds.add((Command)reconnConnCmd);
        }
    }

    protected AbstractReconnectConnectionCommand createReconnCMD(Connection connection, IInterfaceElement interfaceElement, boolean isSourceReconnect, FBNetwork fbn) {
        DataType type = interfaceElement.getType();
        if (type instanceof EventType) {
            return new ReconnectEventConnectionCommand(connection, isSourceReconnect, interfaceElement, fbn);
        }
        if (type instanceof AdapterType) {
            return new ReconnectAdapterConnectionCommand(connection, isSourceReconnect, interfaceElement, fbn);
        }
        return new ReconnectDataConnectionCommand(connection, isSourceReconnect, interfaceElement, fbn);
    }

    protected static AbstractConnectionCreateCommand createConnCreateCMD(IInterfaceElement interfaceElement, FBNetwork fbn) {
        DataType type = interfaceElement.getType();
        if (type instanceof EventType) {
            return new EventConnectionCreateCommand(fbn);
        }
        if (type instanceof AdapterType) {
            return new AdapterConnectionCreateCommand(fbn);
        }
        return new DataConnectionCreateCommand(fbn);
    }

    protected abstract void createNewFB();

    protected static class ConnData {
        private final IInterfaceElement source;
        private final IInterfaceElement dest;

        public ConnData(IInterfaceElement source, IInterfaceElement dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

