/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.StructManipulatorEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.StructTreeNode;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeDropdown;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class StructManipulatorSection
extends AbstractSection
implements CommandStackEventListener {
    private static final String STRUCT_TYPE = "STRUCT_TYPE";
    protected CLabel muxLabel;
    protected TreeViewer memberVarViewer;
    protected Button openEditorButton;
    protected boolean initTree = true;
    protected TableViewer muxStructSelector;
    protected DataTypeDropdown typeDropDown;

    protected FBNetworkElement getInputType(Object input) {
        if (input instanceof StructManipulatorEditPart) {
            return ((StructManipulatorEditPart)((Object)input)).getModel();
        }
        if (input instanceof StructManipulator) {
            return (StructManipulator)input;
        }
        return null;
    }

    protected StructManipulator getType() {
        if (this.type instanceof StructManipulator) {
            return (StructManipulator)this.type;
        }
        return null;
    }

    private void disableOpenEditorForAnyType(String newStructName) {
        this.openEditorButton.setEnabled(!"ANY_STRUCT".contentEquals(newStructName));
    }

    private void createStructSelector(Composite composite) {
        Composite structComp = this.getWidgetFactory().createComposite(composite);
        structComp.setLayout((Layout)new GridLayout(3, false));
        structComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.muxLabel = this.getWidgetFactory().createCLabel(structComp, Messages.StructManipulatorSection_STRUCTURED_TYPE);
        this.createStructSelectionField(structComp);
        this.openEditorButton = new Button(structComp, 8);
        this.openEditorButton.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        this.openEditorButton.addListener(13, e -> OpenStructMenu.openStructEditor((IFile)this.getType().getStructType().getPaletteEntry().getFile()));
    }

    private void createStructSelectionField(Composite parent) {
        this.muxStructSelector = StructManipulatorSection.createTableViewer(parent);
        this.muxStructSelector.setCellEditors(this.createCellEditors());
        this.muxStructSelector.setColumnProperties(new String[]{STRUCT_TYPE});
        this.muxStructSelector.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.muxStructSelector.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (StructManipulatorSection.STRUCT_TYPE.equals(property) && element != null) {
                    StructManipulatorSection.this.handleStructSelectionChanged(value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                if (StructManipulatorSection.STRUCT_TYPE.equals(property)) {
                    return StructManipulatorSection.this.getType().getStructType().getName();
                }
                return "Could not load";
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
    }

    private static TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2064);
        Table table = viewer.getTable();
        new TableColumn(table, 0).setWidth(150);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        return viewer;
    }

    protected CellEditor[] createCellEditors() {
        this.typeDropDown = new DataTypeDropdown(new DataTypeLibrary(), this.muxStructSelector){

            protected List<DataType> getDataTypesSorted() {
                return super.getDataTypesSorted().stream().filter(Objects::nonNull).filter(StructuredType.class::isInstance).collect(Collectors.toList());
            }
        };
        return new CellEditor[]{this.typeDropDown};
    }

    protected void refreshStructTypeTable() {
        this.memberVarViewer.setInput((Object)this.getType());
    }

    protected void handleStructSelectionChanged(String newStructName) {
        if (this.getType() != null) {
            this.disableOpenEditorForAnyType(newStructName);
            if (this.newStructSelected(newStructName)) {
                StructuredType newStruct = this.getDataTypeLib().getStructuredType(newStructName);
                ChangeStructCommand cmd = new ChangeStructCommand(this.getType(), newStruct);
                this.commandStack.execute((Command)cmd);
                StructManipulatorSection.updateStructManipulatorFB(cmd.getNewMux());
            }
        }
    }

    public boolean newStructSelected(String newStructName) {
        return !newStructName.contentEquals(this.getType().getStructType().getName()) && this.getDataTypeLib().getStructuredType(newStructName).getName().equals(newStructName);
    }

    protected static void updateStructManipulatorFB(StructManipulator newMux) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)activeEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.flush();
            Object obj = viewer.getEditPartRegistry().get(newMux);
            viewer.select((EditPart)obj);
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
            if (view instanceof PropertySheet) {
                ((PropertySheet)view).selectionChanged((IWorkbenchPart)activeEditor, viewer.getSelection());
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createStructSelector(parent);
        Group memberVarGroup = this.getWidgetFactory().createGroup(parent, Messages.StructManipulatorSection_Contained_variables);
        this.createMemberVariableViewer((Composite)memberVarGroup);
        memberVarGroup.setLayout((Layout)new GridLayout(1, true));
        memberVarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createMemberVariableViewer(Composite parent) {
        this.memberVarViewer = this.createTreeViewer(parent);
        StructManipulatorSection.configureTreeLayout(this.memberVarViewer);
        this.memberVarViewer.setContentProvider((IContentProvider)new StructTreeNode.StructTreeContentProvider());
        this.memberVarViewer.setLabelProvider((IBaseLabelProvider)new StructTreeNode.StructTreeLabelProvider());
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.createContextMenu(this.memberVarViewer.getControl());
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent);
    }

    private void createContextMenu(Control ctrl) {
        Menu openEditorMenu = new Menu((Control)this.memberVarViewer.getTree());
        final MenuItem openItem = new MenuItem(openEditorMenu, 0);
        openItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredType sel = StructManipulatorSection.this.getSelectedStructuredType();
                if (sel != null) {
                    OpenStructMenu.openStructEditor((IFile)sel.getPaletteEntry().getFile());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        openEditorMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                StructuredType type = StructManipulatorSection.this.getSelectedStructuredType();
                openItem.setEnabled(type != null && !type.getName().contentEquals("ANY_STRUCT"));
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        ctrl.setMenu(openEditorMenu);
    }

    private StructuredType getSelectedStructuredType() {
        StructTreeNode selected = (StructTreeNode)this.memberVarViewer.getTree().getSelection()[0].getData();
        VarDeclaration varDecl = selected.getVariable();
        if (varDecl.getType() instanceof StructuredType) {
            return (StructuredType)varDecl.getType();
        }
        return null;
    }

    private static void configureTreeLayout(TreeViewer viewer) {
        TreeViewerColumn variableName = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn variableType = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn comment = new TreeViewerColumn(viewer, 16384);
        viewer.getTree().setHeaderVisible(true);
        variableName.getColumn().setResizable(true);
        variableType.getColumn().setResizable(true);
        variableName.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_NAME);
        variableType.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_TYPE);
        comment.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_COMMENT);
        variableName.getColumn().setWidth(200);
        variableType.getColumn().setWidth(100);
        comment.getColumn().setWidth(800);
    }

    public void refresh() {
        if (this.getType() != null && this.getType().getFbNetwork() != null && !this.blockRefresh) {
            this.refreshStructTypeTable();
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackEventListener((CommandStackEventListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.muxLabel.setEnabled(false);
            this.muxStructSelector.getTable().setEnabled(false);
            this.memberVarViewer.setInput(null);
        }
        this.setType(input);
        if (this.initTree) {
            StructTreeNode node = this.initTree(this.getType(), this.memberVarViewer);
            ((StructTreeNode.StructTreeContentProvider)this.memberVarViewer.getContentProvider()).setRoot(node);
        }
        this.disableOpenEditorForAnyType(this.getType().getStructType().getName());
        this.muxStructSelector.setInput((Object)new String[]{this.getType().getStructType().getName()});
        this.typeDropDown.setDataTypeLibrary(this.getDataTypeLib());
        if (this.commandStack != null) {
            this.commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public StructTreeNode initTree(StructManipulator struct, TreeViewer viewer) {
        StructuredType structuredType = struct.getPaletteEntry().getTypeLibrary().getDataTypeLibrary().getStructuredType(struct.getStructType().getName());
        CheckableStructTreeNode root = CheckableStructTreeNode.initTree((StructManipulator)struct, (StructuredType)structuredType);
        if (viewer != null) {
            root.setViewer(viewer);
        }
        return root;
    }

    public void dispose() {
        super.dispose();
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        Command command;
        if ((event.getDetail() == 32 || event.getDetail() == 16) && (command = event.getCommand()) instanceof ChangeStructCommand) {
            ChangeStructCommand cmd = (ChangeStructCommand)command;
            if (cmd.getOldMux() == this.getType() || cmd.getNewMux() == this.getType()) {
                if (event.getDetail() == 32) {
                    StructManipulatorSection.updateStructManipulatorFB(cmd.getOldMux());
                } else if (event.getDetail() == 16) {
                    StructManipulatorSection.updateStructManipulatorFB(cmd.getNewMux());
                }
            }
            this.refreshStructTypeTable();
        }
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

