/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.CustomTextCellEditor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InterfaceElementSection
extends AbstractSection {
    private Section connectionSection;
    private TableViewer connectionsViewer;
    private static final String TARGET = "target";
    private static final String PIN = "pin";
    private static final String COMMENT = "comment";
    private static final int TARGET_PIN_WIDTH = 100;
    private static final int COMMENT_WIDTH = 200;
    private Text typeText;
    private Text commentText;
    private Text parameterText;
    private Text currentParameterText;
    private CLabel parameterTextCLabel;
    private CLabel currentParameterTextCLabel;
    private Button openEditorButton;
    private Section infoSection;
    private AddDeleteWidget deleteButton;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInstanceInfoSection(this.getLeftComposite());
        this.createTypeInfoSection(this.getLeftComposite());
        this.createConnectionDisplaySection(this.getRightComposite());
    }

    private void createConnectionDisplaySection(Composite parent) {
        this.connectionSection = this.getWidgetFactory().createSection(parent, 322);
        this.connectionSection.setText(Messages.InterfaceElementSection_ConnectionGroup);
        this.connectionSection.setLayout((Layout)new GridLayout(1, false));
        this.connectionSection.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        Composite composite = this.getWidgetFactory().createComposite((Composite)this.connectionSection);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.deleteButton = new AddDeleteWidget();
        this.deleteButton.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.deleteButton.setVisibleCreateButton(false);
        this.connectionsViewer = this.createConnectionsViewer(composite);
        this.deleteButton.bindToTableViewer(this.connectionsViewer, (CommandExecutor)this, ref -> null, ref -> new DeleteConnectionCommand((Connection)ref));
        this.connectionSection.setClient((Control)composite);
    }

    private TableViewer createConnectionsViewer(Composite parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout((Layout)InterfaceElementSection.createTableLayout(viewer.getTable()));
        viewer.setColumnProperties(new String[]{TARGET, PIN, COMMENT});
        viewer.setCellModifier((ICellModifier)new ConnectionCellModifier(viewer));
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = new CustomTextCellEditor((Composite)viewer.getTable());
        viewer.setCellEditors(cellEditorArray);
        viewer.setLabelProvider((IBaseLabelProvider)new ConnectionTableLabelProvider());
        viewer.setContentProvider((IContentProvider)new ConnectionContentProvider());
        return viewer;
    }

    private static TableLayout createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Target);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Pin);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        return layout;
    }

    private void createTypeInfoSection(Composite parent) {
        Section typeInfoSection = this.getWidgetFactory().createSection(parent, 322);
        typeInfoSection.setText(String.valueOf(FordiacMessages.TypeInfo) + ":");
        typeInfoSection.setLayout((Layout)new GridLayout(1, false));
        typeInfoSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.getWidgetFactory().createComposite((Composite)typeInfoSection);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Comment) + ":");
        this.commentText = this.createGroupText(composite, false);
        this.commentText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Type) + ":");
        this.typeText = this.createGroupText(composite, false);
        this.openEditorButton = new Button(this.typeText.getParent(), 8);
        this.openEditorButton.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        this.openEditorButton.addListener(13, ev -> OpenStructMenu.openStructEditor((IFile)((VarDeclaration)this.getType()).getType().getPaletteEntry().getFile()));
        this.parameterTextCLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.DefaultValue) + ":");
        this.parameterText = this.createGroupText(composite, false);
        this.parameterText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        typeInfoSection.setClient((Control)composite);
    }

    private void createInstanceInfoSection(Composite parent) {
        this.infoSection = this.getWidgetFactory().createSection(parent, 322);
        this.infoSection.setLayout((Layout)new GridLayout(1, false));
        this.infoSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.getWidgetFactory().createComposite((Composite)this.infoSection);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.currentParameterTextCLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.InitialValue) + ":");
        this.currentParameterText = this.createGroupText(composite, true);
        this.currentParameterText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeValueCommand((VarDeclaration)this.getType(), this.currentParameterText.getText()));
            this.addContentAdapter();
        });
        this.infoSection.setClient((Control)composite);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.refreshParameterVisibility();
            FBNetworkElement fb = this.getType().getFBNetworkElement();
            if (fb != null) {
                this.infoSection.setText(MessageFormat.format(Messages.InterfaceElementSection_Instance, fb.getName(), this.getPinName()));
            } else {
                this.infoSection.setText(Messages.InterfaceElementSection_InterfaceElement);
            }
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            String itype = "";
            this.openEditorButton.setEnabled(this.getType().getType() instanceof StructuredType || this.getType().getType() instanceof AdapterType);
            itype = this.getType() instanceof VarDeclaration ? this.setParameterAndType() : FordiacMessages.Event;
            this.typeText.setText(itype);
            this.refreshConnectionsViewer();
            if (fb != null) {
                this.setEditable(!fb.isContainedInTypedInstance());
            }
        }
        this.commandStack = commandStackBuffer;
    }

    private Object getPinName() {
        return this.getType().getName() != null ? this.getType().getName() : "";
    }

    private void refreshParameterVisibility() {
        boolean isDataIO = this.getType() instanceof VarDeclaration && !(this.getType() instanceof AdapterDeclaration);
        this.parameterTextCLabel.setVisible(isDataIO);
        this.parameterText.setVisible(isDataIO);
        this.currentParameterTextCLabel.setVisible(isDataIO && this.getType().isIsInput());
        this.currentParameterText.setVisible(isDataIO && this.getType().isIsInput());
    }

    private void refreshConnectionsViewer() {
        if (this.getType().isIsInput()) {
            this.connectionSection.setText(Messages.InterfaceElementSection_InConnections);
        } else {
            this.connectionSection.setText(Messages.InterfaceElementSection_OutConnections);
        }
        this.connectionsViewer.setInput((Object)this.getType());
    }

    private void setEditable(boolean editable) {
        this.currentParameterText.setEditable(editable);
        this.currentParameterText.setEnabled(editable);
        this.deleteButton.setVisibleDeleteButton(editable);
    }

    protected String setParameterAndType() {
        IInterfaceElement ie;
        FBType fbType;
        String itype;
        VarDeclaration varDecl = (VarDeclaration)this.getType();
        String string = itype = varDecl.getType() != null ? varDecl.getType().getName() : "";
        if (varDecl.isIsInput() && varDecl.getFBNetworkElement() != null && (fbType = varDecl.getFBNetworkElement().getType()) != null && (ie = fbType.getInterfaceList().getInterfaceElement(varDecl.getName())) instanceof VarDeclaration) {
            this.parameterText.setText(InterfaceElementSection.getValueFromVarDecl((VarDeclaration)ie));
            if (varDecl.getType() instanceof StructuredType) {
                itype = InterfaceElementSection.getStructTypes((StructuredType)this.getType().getType());
            }
        }
        this.currentParameterText.setText(InterfaceElementSection.getValueFromVarDecl(varDecl));
        return itype;
    }

    private static String getValueFromVarDecl(VarDeclaration varDecl) {
        return varDecl.getValue() != null ? varDecl.getValue().getValue() : "";
    }

    private static String getStructTypes(StructuredType st) {
        EList list = st.getMemberVariables();
        StringBuilder sb = new StringBuilder();
        sb.append(st.getName());
        sb.append(": (");
        boolean printString = false;
        for (VarDeclaration v : list) {
            if (v.getType() != null) {
                sb.append(v.getType().getName());
                printString = true;
            } else {
                sb.append("not set");
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(')');
        return printString ? sb.toString() : "";
    }

    protected void setInputCode() {
        this.connectionsViewer.setInput(null);
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    protected Object getInputType(Object input) {
        if (input instanceof InterfaceEditPart) {
            return ((InterfaceEditPart)input).getModel();
        }
        if (input instanceof ValueEditPart) {
            return ((ValueEditPart)input).getModel().getVarDeclaration();
        }
        return null;
    }

    protected void setInputInit() {
    }

    private class ConnectionCellModifier
    implements ICellModifier {
        private final TableViewer viewer;

        public ConnectionCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return InterfaceElementSection.COMMENT.equals(property);
        }

        public Object getValue(Object element, String property) {
            if (InterfaceElementSection.COMMENT.equals(property)) {
                Connection con = (Connection)element;
                return con.getComment() != null ? con.getComment() : "";
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            if (InterfaceElementSection.COMMENT.equals(property)) {
                Connection con = (Connection)data;
                InterfaceElementSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)con, value.toString()));
                this.viewer.refresh(data);
            }
        }
    }

    private static class ConnectionContentProvider
    implements IStructuredContentProvider {
        private ConnectionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IInterfaceElement) {
                IInterfaceElement element = (IInterfaceElement)inputElement;
                if (element.isIsInput() && element.getFBNetworkElement() != null || !element.isIsInput() && element.getFBNetworkElement() == null) {
                    return element.getInputConnections().toArray();
                }
                return element.getOutputConnections().toArray();
            }
            return new Object[0];
        }
    }

    private class ConnectionTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public static final int TARGET_COL_INDEX = 0;
        public static final int PIN_COL_INDEX = 1;
        public static final int COMMENT_COL_INDEX = 2;
        AdapterFactoryLabelProvider labelProvider;

        private ConnectionTableLabelProvider() {
            this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)InterfaceElementSection.this.getAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Connection con;
            IInterfaceElement ie;
            if (element instanceof Connection && (ie = this.getInterfaceElement(con = (Connection)element)) != null) {
                switch (columnIndex) {
                    case 0: {
                        if (ie.getFBNetworkElement() == null) break;
                        return this.labelProvider.getImage((Object)ie.getFBNetworkElement());
                    }
                    case 1: {
                        return this.labelProvider.getImage((Object)ie);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Connection con;
            IInterfaceElement ie;
            if (element instanceof Connection && (ie = this.getInterfaceElement(con = (Connection)element)) != null) {
                switch (columnIndex) {
                    case 0: {
                        if (ie.getFBNetworkElement() != null) {
                            return ie.getFBNetworkElement().getName();
                        }
                        if (!(ie.eContainer().eContainer() instanceof CompositeFBType)) break;
                        return ((CompositeFBType)ie.eContainer().eContainer()).getName();
                    }
                    case 1: {
                        return ie.getName();
                    }
                    case 2: {
                        return con.getComment() != null ? con.getComment() : "";
                    }
                }
            }
            return element.toString();
        }

        private IInterfaceElement getInterfaceElement(Connection con) {
            return InterfaceElementSection.this.getType().equals(con.getSource()) ? con.getDestination() : con.getSource();
        }
    }
}

