/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenTypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (sel != null) {
            FBType type;
            Object obj = sel.getFirstElement();
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (obj instanceof FBNetworkElement && (type = ((FBNetworkElement)obj).getType()) != null) {
                OpenTypeHandler.openTypeEditor(type.getPaletteEntry().getFile());
            }
        }
        return Status.OK_STATUS;
    }

    private static void openTypeEditor(IFile file) {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                activePage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            catch (Exception e) {
                ApplicationPlugin.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        ISelection sel = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (obj instanceof FBNetworkElement) {
                this.setBaseEnabled(((FBNetworkElement)obj).getType() != null);
            }
        }
    }
}

