/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.List;
import org.eclipse.fordiac.ide.application.commands.AddElementsToSubAppCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;

public class NewSubAppCommand
extends AbstractCreateFBNetworkElementCommand {
    private final List<?> parts;
    private final AddElementsToSubAppCommand addElements;
    private MapToCommand mapSubappCmd;

    public NewSubAppCommand(FBNetwork fbNetwork, List<?> selection, int x, int y) {
        super(fbNetwork, (FBNetworkElement)LibraryElementFactory.eINSTANCE.createSubApp(), x, y);
        this.getSubApp().setSubAppNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        this.addElements = new AddElementsToSubAppCommand(this.getSubApp(), selection);
        this.checkMapping(selection);
        this.parts = selection;
    }

    public boolean canExecute() {
        return super.canExecute() && this.allElementsInSameFBnetwork();
    }

    private boolean allElementsInSameFBnetwork() {
        for (Object o : this.parts) {
            Object model;
            if (!(o instanceof EditPart) || !((model = ((EditPart)o).getModel()) instanceof FBNetworkElement) || ((FBNetworkElement)model).getFbNetwork() == this.getFBNetwork()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        super.execute();
        this.addElements.execute();
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.execute();
        }
    }

    public void redo() {
        super.redo();
        this.addElements.redo();
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.redo();
        }
    }

    public void undo() {
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.undo();
        }
        this.addElements.undo();
        super.undo();
    }

    private void checkMapping(List<?> selection) {
        Resource res = null;
        for (Object ne : selection) {
            if (!(ne instanceof EditPart) || !(((EditPart)ne).getModel() instanceof FBNetworkElement)) continue;
            FBNetworkElement element = (FBNetworkElement)((EditPart)ne).getModel();
            if (element.isMapped()) {
                if (res == null) {
                    res = element.getResource();
                    continue;
                }
                if (res == element.getResource()) continue;
                return;
            }
            return;
        }
        if (res != null) {
            this.mapSubappCmd = new MapToCommand((FBNetworkElement)this.getSubApp(), res);
        }
    }

    protected final InterfaceList getTypeInterfaceList() {
        return LibraryElementFactory.eINSTANCE.createInterfaceList();
    }

    protected String getInitalInstanceName() {
        return "SubApp";
    }

    private SubApp getSubApp() {
        return (SubApp)this.getElement();
    }
}

