/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.application.commands.MoveElementsFromSubAppCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.swt.graphics.Point;

public class CutAndPasteFromSubAppCommand
extends MoveElementsFromSubAppCommand {
    private CopyStatus copyStatus = CopyStatus.BEFORE_REMOVED_FROM_SUBAPP;

    public CutAndPasteFromSubAppCommand(Collection<FBNetworkElement> elements, Point destination) {
        super(elements, destination);
    }

    @Override
    public boolean canExecute() {
        return this.copyStatus == CopyStatus.REMOVED_FROM_SUBAPP || super.canExecute();
    }

    @Override
    public void undo() {
        switch (this.copyStatus) {
            case BEFORE_REMOVED_FROM_SUBAPP: {
                break;
            }
            case REMOVED_FROM_SUBAPP: {
                this.undoRemoveElementsFromSubapp();
                this.copyStatus = CopyStatus.INSERTED;
                break;
            }
            case INSERTED: {
                this.undoRemoveElementsFromSubapp();
                this.undoAddElementsToDestination();
                this.copyStatus = CopyStatus.BEFORE_REMOVED_FROM_SUBAPP;
                break;
            }
        }
    }

    @Override
    public void redo() {
        switch (this.copyStatus) {
            case BEFORE_REMOVED_FROM_SUBAPP: {
                this.redoAddElementsToDestination();
                this.redoRemoveElementsFromSubapp();
                this.copyStatus = CopyStatus.INSERTED;
                break;
            }
            case REMOVED_FROM_SUBAPP: {
                this.redoAddElementsToDestination();
                this.copyStatus = CopyStatus.INSERTED;
                break;
            }
            case INSERTED: {
                this.redoRemoveElementsFromSubapp();
                this.copyStatus = CopyStatus.REMOVED_FROM_SUBAPP;
                break;
            }
        }
    }

    @Override
    public void execute() {
        switch (this.copyStatus) {
            case BEFORE_REMOVED_FROM_SUBAPP: {
                this.removeElementsFromSubapp();
                if (!this.createSubAppInterfaceElementCommands.isEmpty()) {
                    this.createSubAppInterfaceElementCommands.undo();
                }
                this.copyStatus = CopyStatus.REMOVED_FROM_SUBAPP;
                break;
            }
            case REMOVED_FROM_SUBAPP: {
                if (!this.createSubAppInterfaceElementCommands.isEmpty()) {
                    this.createSubAppInterfaceElementCommands.redo();
                }
                this.addElementsToDestination();
                this.copyStatus = CopyStatus.INSERTED;
                break;
            }
        }
    }

    public SubApp getSourceSubApp() {
        return this.sourceSubApp;
    }

    @Override
    public List<FBNetworkElement> getElements() {
        return this.elements;
    }

    public void setPastePos(Point pasteRefPosition) {
        this.setDestination(pasteRefPosition);
    }

    private static enum CopyStatus {
        BEFORE_REMOVED_FROM_SUBAPP,
        REMOVED_FROM_SUBAPP,
        INSERTED;

    }
}

