/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.gef.provider.VersionContentProvider;
import org.eclipse.fordiac.ide.gef.provider.VersionLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeApplicationDomainCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAuthorCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeClassificationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDateCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDescriptionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFunctionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeIdentifcationTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOrganizationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeRemarksCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStandardCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVersionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewVersionInfoCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteVersionInfoCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TypeInfoWidget
implements CommandExecutor {
    private final FormToolkit widgetFactory;
    private Consumer<Command> commandExecutor;
    private LibraryElement type;
    private Text standardText;
    private Text classificationText;
    private Text domainText;
    private Text functionText;
    private Text typeText;
    private Text descriptionText;
    private TableViewer versionViewer;
    private AddDeleteWidget addDeleteVersionInfoButtons;
    private static final String VERSION_PROPERTY = "version";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String DATE_PROPERTY = "date";
    private static final String REMARKS_PROPERTY = "remarks";

    public TypeInfoWidget(FormToolkit widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    private FormToolkit getWidgetFactory() {
        return this.widgetFactory;
    }

    public Composite createControls(Composite parent) {
        Composite rootComposite = this.getWidgetFactory().createComposite(parent);
        rootComposite.setLayout((Layout)new GridLayout(2, true));
        rootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createControls(this.createComposite(rootComposite), this.createComposite(rootComposite));
        return rootComposite;
    }

    public void createControls(Composite leftComposite, Composite rightComposite) {
        this.createIdentificationGroup(leftComposite);
        this.createVersionInfoGroup(rightComposite);
    }

    private void createIdentificationGroup(Composite parent) {
        Group identificationGroup = this.createGroup(parent, FordiacMessages.Identification);
        identificationGroup.setLayout((Layout)new GridLayout(2, false));
        identificationGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Standard) + ":");
        this.standardText = this.createGroupText((Composite)identificationGroup, true);
        this.standardText.addModifyListener(e -> this.executeCommand((Command)new ChangeStandardCommand(this.type, this.standardText.getText())));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Classification) + ":");
        this.classificationText = this.createGroupText((Composite)identificationGroup, true);
        this.classificationText.addModifyListener(e -> this.executeCommand((Command)new ChangeClassificationCommand(this.type, this.classificationText.getText())));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.ApplicationDomain) + ":");
        this.domainText = this.createGroupText((Composite)identificationGroup, true);
        this.domainText.addModifyListener(e -> this.executeCommand((Command)new ChangeApplicationDomainCommand(this.type, this.domainText.getText())));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Function) + ":");
        this.functionText = this.createGroupText((Composite)identificationGroup, true);
        this.functionText.addModifyListener(e -> this.executeCommand((Command)new ChangeFunctionCommand(this.type, this.functionText.getText())));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Type) + ":");
        this.typeText = this.createGroupText((Composite)identificationGroup, true);
        this.typeText.addModifyListener(e -> this.executeCommand((Command)new ChangeIdentifcationTypeCommand(this.type, this.typeText.getText())));
        Label label = this.getWidgetFactory().createLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Description) + ":");
        label.setLayoutData((Object)new GridData(0, 128, false, false));
        this.descriptionText = this.getWidgetFactory().createText((Composite)identificationGroup, "", 2882);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(e -> this.executeCommand((Command)new ChangeDescriptionCommand(this.type, this.descriptionText.getText())));
    }

    private void createVersionInfoGroup(Composite parent) {
        Group versionInfoGroup = this.createGroup(parent, FordiacMessages.VersionInfo);
        versionInfoGroup.setLayout((Layout)new GridLayout(2, false));
        versionInfoGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addDeleteVersionInfoButtons = new AddDeleteWidget();
        this.addDeleteVersionInfoButtons.createControls((Composite)versionInfoGroup, this.getWidgetFactory());
        this.versionViewer = TableWidgetFactory.createPropertyTableViewer((Composite)versionInfoGroup);
        TypeInfoWidget.configureTableLayout(this.versionViewer.getTable());
        Table table = this.versionViewer.getTable();
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.versionViewer.setColumnProperties(new String[]{VERSION_PROPERTY, ORGANIZATION_PROPERTY, AUTHOR_PROPERTY, DATE_PROPERTY, REMARKS_PROPERTY});
        this.addDeleteVersionInfoButtons.bindToTableViewer(this.versionViewer, (CommandExecutor)this, ref -> new AddNewVersionInfoCommand(this.type), ref -> new DeleteVersionInfoCommand(this.type, (VersionInfo)ref));
        this.versionViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                switch (property) {
                    case "version": {
                        return ((VersionInfo)element).getVersion();
                    }
                    case "organization": {
                        return ((VersionInfo)element).getOrganization();
                    }
                    case "author": {
                        return ((VersionInfo)element).getAuthor();
                    }
                    case "date": {
                        return ((VersionInfo)element).getDate();
                    }
                }
                return ((VersionInfo)element).getRemarks();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                VersionInfo data = (VersionInfo)tableItem.getData();
                ChangeRemarksCommand cmd = null;
                switch (property) {
                    case "version": {
                        cmd = new ChangeVersionCommand(data, value.toString());
                        break;
                    }
                    case "organization": {
                        cmd = new ChangeOrganizationCommand(data, value.toString());
                        break;
                    }
                    case "author": {
                        cmd = new ChangeAuthorCommand(data, value.toString());
                        break;
                    }
                    case "date": {
                        cmd = new ChangeDateCommand(data, value.toString());
                        break;
                    }
                    default: {
                        cmd = new ChangeRemarksCommand(data, value.toString());
                    }
                }
                TypeInfoWidget.this.executeCommand((Command)cmd);
                TypeInfoWidget.this.versionViewer.refresh((Object)data);
            }
        });
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Version);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Organization);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Author);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.Date);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.Remarks);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 100));
        table.setLayout((Layout)layout);
    }

    private Composite createComposite(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private Text createGroupText(Composite group, boolean editable) {
        Text text = this.getWidgetFactory().createText(group, "", 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    public void initialize(LibraryElement type, Consumer<Command> commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.type = type;
    }

    public void refresh() {
        if (this.type != null) {
            Consumer<Command> commandExecutorBuffer = this.commandExecutor;
            this.commandExecutor = null;
            if (this.type.getIdentification() != null) {
                Identification id = this.type.getIdentification();
                this.standardText.setText(id.getStandard() != null ? id.getStandard() : "");
                this.classificationText.setText(id.getClassification() != null ? id.getClassification() : "");
                this.domainText.setText(id.getApplicationDomain() != null ? id.getApplicationDomain() : "");
                this.functionText.setText(id.getFunction() != null ? id.getFunction() : "");
                this.typeText.setText(id.getType() != null ? id.getType() : "");
                this.descriptionText.setText(id.getDescription() != null ? id.getDescription() : "");
            }
            if (this.type.getVersionInfo() != null) {
                this.versionViewer.setInput((Object)this.type);
            }
            this.commandExecutor = commandExecutorBuffer;
        }
    }

    public void executeCommand(Command cmd) {
        if (this.commandExecutor != null) {
            this.commandExecutor.accept(cmd);
        }
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 32);
        group.setText(text);
        this.getWidgetFactory().adapt((Composite)group);
        return group;
    }

    public void setEnabled(boolean enablement) {
        this.standardText.setEnabled(enablement);
        this.classificationText.setEnabled(enablement);
        this.domainText.setEnabled(enablement);
        this.functionText.setEnabled(enablement);
        this.typeText.setEnabled(enablement);
        this.descriptionText.setEnabled(enablement);
        this.addDeleteVersionInfoButtons.setVisible(enablement);
        this.versionViewer.setCellModifier(null);
    }
}

