/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFbTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInternalFBOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.IndexUpDown;
import org.eclipse.fordiac.ide.model.commands.create.CreateInternalFBCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInternalFBCommand;
import org.eclipse.fordiac.ide.model.commands.insert.InsertFBCommand;
import org.eclipse.fordiac.ide.model.edit.providers.InternalFBLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class InternalFbsSection
extends AbstractSection
implements I4diacTableUtil {
    private static final String FB_NAME = "NAME";
    private static final String FB_TYPE = "TYPE";
    private static final String FB_COMMENT = "COMMENT";
    private TableViewer internalFbsViewer;

    protected BaseFBType getType() {
        return (BaseFBType)this.type;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInternalFbsControls(parent);
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
        OpenStructMenu.addTo((TableViewer)this.internalFbsViewer);
    }

    public void createInternalFbsControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.internalFbsViewer = TableWidgetFactory.createTableViewer((Composite)composite);
        InternalFbsSection.configureTableLayout(this.internalFbsViewer.getTable());
        this.internalFbsViewer.setColumnProperties(new String[]{FB_NAME, FB_TYPE, FB_COMMENT});
        this.internalFbsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.internalFbsViewer.setLabelProvider((IBaseLabelProvider)new InternalFBLabelProvider());
        this.internalFbsViewer.setCellModifier((ICellModifier)new InternalFBsCellModifier());
        buttons.bindToTableViewer(this.internalFbsViewer, (CommandExecutor)this, ref -> new CreateInternalFBCommand(this.getType(), this.getInsertionIndex(), this.getName(), this.getFBTypePaletteEntry()), ref -> new DeleteInternalFBCommand(this.getType(), this.getLastSelectedFB()), ref -> new ChangeInternalFBOrderCommand(this.getType(), (FB)ref, IndexUpDown.UP), ref -> new ChangeInternalFBOrderCommand(this.getType(), (FB)ref, IndexUpDown.DOWN));
    }

    private PaletteEntry getFBTypePaletteEntry() {
        FB fb = this.getLastSelectedFB();
        return fb != null ? fb.getType().getPaletteEntry() : null;
    }

    private String getName() {
        FB fb = this.getLastSelectedFB();
        return fb != null ? fb.getName() : null;
    }

    private int getInsertionIndex() {
        FB fb = this.getLastSelectedFB();
        if (fb == null) {
            return this.getType().getInternalFbs().size();
        }
        return this.getType().getInternalFbs().indexOf((Object)fb) + 1;
    }

    private FB getLastSelectedFB() {
        IStructuredSelection selection = this.internalFbsViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (FB)selection.toList().get(selection.toList().size() - 1);
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Name);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Type);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        table.setLayout((Layout)layout);
    }

    private static CellEditor[] createCellEditors(Table table) {
        TextCellEditor fbNameEditor = new TextCellEditor((Composite)table);
        ((Text)fbNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        TextCellEditor fbTypeEditor = new TextCellEditor((Composite)table);
        ((Text)fbTypeEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        return new CellEditor[]{fbNameEditor, fbTypeEditor, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
    }

    @Override
    protected void setInputCode() {
        this.internalFbsViewer.setCellModifier(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.internalFbsViewer.setInput((Object)this.getType().getInternalFbs());
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    protected void setInputInit() {
        this.internalFbsViewer.setCellEditors(InternalFbsSection.createCellEditors(this.internalFbsViewer.getTable()));
    }

    public TableViewer getViewer() {
        return this.internalFbsViewer;
    }

    public Object getEntry(int index) {
        return this.getType().getInternalFbs().get(index);
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof FB) {
            FBType fbTypeEntry = (FBType)entry;
            cmd.add((Command)new InsertFBCommand(this.getType().getInternalFbs(), fbTypeEntry, index));
        }
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        FB fbEntry = (FB)this.getEntry(index);
        cmd.add((Command)new DeleteInternalFBCommand(this.getType(), fbEntry));
        return fbEntry;
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.getViewer().refresh();
    }

    private final class InternalFBsCellModifier
    implements ICellModifier {
        private InternalFBsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            FB fb = (FB)element;
            switch (property) {
                case "NAME": {
                    return fb.getName();
                }
                case "TYPE": {
                    return fb.getTypeName();
                }
                case "COMMENT": {
                    return fb.getComment();
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            FB fb = (FB)tableItem.getData();
            ChangeCommentCommand cmd = null;
            switch (property) {
                case "NAME": {
                    cmd = new ChangeNameCommand((INamedElement)fb, value.toString());
                    break;
                }
                case "TYPE": {
                    FBTypePaletteEntry fbTypeEntry = InternalFbsSection.this.getPalette().getFBTypeEntry(value.toString());
                    if (fbTypeEntry == null) {
                        return;
                    }
                    FBType fbType = (FBType)fbTypeEntry.getType();
                    cmd = new ChangeFbTypeCommand(fb, fbType);
                    break;
                }
                default: {
                    cmd = new ChangeCommentCommand((INamedElement)fb, value.toString());
                }
            }
            InternalFbsSection.this.executeCommand((Command)cmd);
            InternalFbsSection.this.internalFbsViewer.refresh((Object)fb);
        }
    }
}

