/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppIENameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class InterfaceElementSection
extends AbstractSection {
    private Text nameText;
    private Text commentText;
    protected CCombo typeCombo;
    private Text parameterText;
    private CLabel valueCLabel;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTypeAndCommentSection(parent);
    }

    protected void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Name) + ":");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.nameText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeSubAppIENameCommand(this.getType(), this.nameText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Comment) + ":");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Type) + ":");
        Composite typeComp = this.getWidgetFactory().createComposite(composite);
        typeComp.setLayout((Layout)new GridLayout(2, false));
        typeComp.setLayoutData((Object)new GridData(4, 0, true, false));
        this.typeCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)typeComp);
        this.typeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.typeCombo.addListener(13, event -> {
            ChangeDataTypeCommand cmd = null;
            if (this.getType() instanceof AdapterDeclaration) {
                AdapterType newType = this.getPalette().getAdapterTypeEntry(this.typeCombo.getText()).getType();
                cmd = this.newChangeTypeCommand((VarDeclaration)this.getType(), (DataType)newType);
            } else if (this.getType() instanceof VarDeclaration) {
                cmd = this.newChangeTypeCommand((VarDeclaration)this.getType(), this.getDataTypeLib().getType(this.typeCombo.getText()));
            }
            this.executeCommand((Command)cmd);
        });
        this.valueCLabel = this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.InitialValue) + ":");
        this.parameterText = this.createGroupText(composite, true);
        this.parameterText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeValueCommand((VarDeclaration)this.getType(), this.parameterText.getText()));
            this.addContentAdapter();
        });
    }

    private void fillTypeCombo(String text) {
        this.typeCombo.removeAll();
        if (this.getType() instanceof Event) {
            EventTypeLibrary.getInstance().getEventTypes().forEach(eType -> this.typeCombo.add(eType.getName()));
        } else if (this.getType() instanceof AdapterDeclaration) {
            this.getPalette().getAdapterTypesSorted().forEach(adp -> this.typeCombo.add(adp.getType().getName()));
        } else if (this.getType() instanceof VarDeclaration) {
            this.getDataTypeLib().getDataTypesSorted().forEach(dataType -> this.typeCombo.add(dataType.getName()));
        }
        if (this.typeCombo.getItems().length > 0) {
            this.typeCombo.setText(text);
        }
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.setEditableFields(this.getType().getFBNetworkElement() instanceof SubApp);
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            String itype = "";
            if (this.getType() instanceof VarDeclaration) {
                VarDeclaration variable = (VarDeclaration)this.getType();
                String string = itype = variable.getType() != null ? variable.getType().getName() : "";
                if (this.getType().isIsInput()) {
                    this.parameterText.setVisible(true);
                    this.valueCLabel.setVisible(true);
                    this.parameterText.setText(variable.getValue() != null ? variable.getValue().getValue() : "");
                } else {
                    this.valueCLabel.setVisible(false);
                    this.parameterText.setVisible(false);
                }
            } else {
                itype = FordiacMessages.Event;
                this.valueCLabel.setVisible(false);
                this.parameterText.setVisible(false);
            }
            this.fillTypeCombo(itype);
        }
        this.commandStack = commandStackBuffer;
    }

    private void setEditableFields(boolean editAble) {
        this.nameText.setEditable(editAble);
        this.nameText.setEnabled(editAble);
        this.commentText.setEditable(editAble);
        this.commentText.setEnabled(editAble);
        this.typeCombo.setEnabled(editAble && this.getType().getInputConnections().isEmpty() && this.getType().getOutputConnections().isEmpty());
    }

    protected ChangeDataTypeCommand newChangeTypeCommand(VarDeclaration data, DataType newType) {
        return new ChangeDataTypeCommand(data, newType);
    }

    protected IInterfaceElement getInputType(Object input) {
        if (input instanceof InterfaceEditPart) {
            return ((InterfaceEditPart)input).getModel();
        }
        if (input instanceof ValueEditPart) {
            return ((ValueEditPart)((Object)input)).getModel().getVarDeclaration();
        }
        return null;
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    @Override
    protected void setInputInit() {
    }

    @Override
    protected void setInputCode() {
    }
}

