/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.AttributeChangeCommand;
import org.eclipse.fordiac.ide.model.commands.create.AttributeCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.AttributeDeleteCommand;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractAttributeSection
extends AbstractSection {
    private TableViewer attributeViewer;
    private static final String NAME_COL = "name";
    private static final String VALUE_COL = "value";
    private static final String TYPE_COL = "type";
    private static final String COMMENT_COL = "comment";

    protected abstract ConfigurableObject getInputType(Object var1);

    @Override
    protected abstract EObject getType();

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteWidget buttons = this.createNewDeleteButton(parent);
        this.createInputInfoGroup(parent);
        this.configureButtonList(buttons, this.attributeViewer);
    }

    private AddDeleteWidget createNewDeleteButton(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(0, 4, false, true));
        AddDeleteWidget buttons = new AddDeleteWidget();
        buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        return buttons;
    }

    private void configureButtonList(AddDeleteWidget buttons, TableViewer attributeViewer) {
        buttons.bindToTableViewer(attributeViewer, (CommandExecutor)this, ref -> AbstractAttributeSection.newCreateCommand((ConfigurableObject)this.getType(), (Attribute)ref), ref -> AbstractAttributeSection.newDeleteCommand((ConfigurableObject)this.getType(), (Attribute)ref));
    }

    private static AttributeCreateCommand newCreateCommand(ConfigurableObject object, Attribute ref) {
        return new AttributeCreateCommand(object, ref);
    }

    private static Command newDeleteCommand(ConfigurableObject object, Attribute ref) {
        return new AttributeDeleteCommand(object, ref);
    }

    private static String[] getDataTypes() {
        List<BaseType1> list = Arrays.asList(BaseType1.values());
        return list.stream().map(BaseType1::getName).collect(Collectors.toList()).toArray(new String[0]);
    }

    private void createInputInfoGroup(Composite parent) {
        this.attributeViewer = TableWidgetFactory.createPropertyTableViewer((Composite)parent, (int)0);
        this.configureTableLayout();
        Table table = this.attributeViewer.getTable();
        this.attributeViewer.setContentProvider((IContentProvider)new InputContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new InputLabelProvider());
        this.attributeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])AbstractAttributeSection.getDataTypes(), (int)8), new TextCellEditor((Composite)table, 514), new TextCellEditor((Composite)table)});
        this.attributeViewer.setColumnProperties(new String[]{NAME_COL, TYPE_COL, VALUE_COL, COMMENT_COL});
        this.attributeViewer.setCellModifier((ICellModifier)new AttributeCellModifier());
    }

    private void configureTableLayout() {
        TableColumn column1 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column1.setText(NAME_COL);
        TableColumn column2 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column2.setText(TYPE_COL);
        TableColumn column3 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column3.setText(VALUE_COL);
        TableColumn column4 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column4.setText(COMMENT_COL);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 90));
        this.attributeViewer.getTable().setLayout((Layout)layout);
    }

    public void refresh() {
        super.refresh();
        if (this.type != null) {
            this.attributeViewer.setInput((Object)this.getType());
        }
    }

    @Override
    protected void setInputCode() {
        this.attributeViewer.setCellModifier(null);
    }

    @Override
    protected void setInputInit() {
    }

    public class AttributeCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return !(element instanceof Attribute) || !AbstractAttributeSection.TYPE_COL.equals(property) || ((Attribute)element).getAttributeDeclaration() == null;
        }

        public Object getValue(Object element, String property) {
            switch (property) {
                case "name": {
                    return ((Attribute)element).getName();
                }
                case "value": {
                    return ((Attribute)element).getValue();
                }
                case "type": {
                    return ((Attribute)element).getType().getValue();
                }
                case "comment": {
                    return ((Attribute)element).getComment();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Attribute data = (Attribute)((TableItem)element).getData();
            AttributeChangeCommand cmd = null;
            switch (property) {
                case "name": {
                    cmd = new AttributeChangeCommand(data, value.toString(), null, null, null);
                    break;
                }
                case "value": {
                    cmd = new AttributeChangeCommand(data, null, value.toString(), null, null);
                    break;
                }
                case "type": {
                    cmd = new AttributeChangeCommand(data, null, null, BaseType1.get((int)((Integer)value)), null);
                    break;
                }
                case "comment": {
                    cmd = new AttributeChangeCommand(data, null, null, null, value.toString());
                }
            }
            AbstractAttributeSection.this.executeCommand((Command)cmd);
            AbstractAttributeSection.this.attributeViewer.refresh((Object)data);
        }
    }

    public static class InputContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Application) {
                return ((Application)inputElement).getAttributes().toArray();
            }
            if (inputElement instanceof Device) {
                return ((Device)inputElement).getAttributes().toArray();
            }
            if (inputElement instanceof Segment) {
                return ((Segment)inputElement).getAttributes().toArray();
            }
            return new Object[0];
        }
    }

    public static class InputLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Attribute) {
                switch (columnIndex) {
                    case 0: {
                        return ((Attribute)element).getName();
                    }
                    case 1: {
                        return ((Attribute)element).getType().getName();
                    }
                    case 2: {
                        return ((Attribute)element).getValue();
                    }
                    case 3: {
                        return ((Attribute)element).getComment() != null ? ((Attribute)element).getComment() : "";
                    }
                }
            }
            return element.toString();
        }
    }
}

