/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ModifiedMoveHandle
extends MoveHandle {
    public static final int SELECTION_FILL_ALPHA = 50;
    public static final int SELECTION_BORDER_WIDTH = 2;
    private static Color selectionColor = null;
    private final Insets insets;

    public static Color getSelectionColor() {
        if (selectionColor == null) {
            Display display = Display.getCurrent();
            selectionColor = display.getSystemColor(26);
        }
        return selectionColor;
    }

    public ModifiedMoveHandle(GraphicalEditPart owner, Insets insets, int arc) {
        super(owner);
        this.insets = insets;
        ((SelectionBorder)this.getBorder()).setArc(arc);
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBorder((Border)new SelectionBorder(0));
        this.setCursor(Cursors.SIZEALL);
    }

    public Insets getInsets() {
        return this.insets;
    }

    static class SelectionBorder
    extends AbstractBorder {
        private int arc;

        public SelectionBorder(int arc) {
            this.arc = arc;
        }

        public void setArc(int arc) {
            this.arc = arc;
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            Rectangle rect = SelectionBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            g.setLineStyle(1);
            g.setLineWidth(2);
            g.setXORMode(false);
            g.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
            g.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
            rect = rect.getShrinked(1, 1);
            g.drawRoundRectangle(rect, this.arc, this.arc);
            g.setAlpha(50);
            g.fillRoundRectangle(rect, this.arc, this.arc);
        }

        public Insets getInsets(IFigure figure) {
            return figure.getInsets();
        }
    }
}

