/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.swt.graphics.Color;

public class ConnectorBorder
extends AbstractBorder {
    private static final int CONNECTOR_SIZE = 5;
    private static final int ADAPTER_SIZE = 9;
    private static final int LR_MARGIN = 6;
    private static final int LR_ADAPTER_MARGIN = 11;
    private final IInterfaceElement editPartModelOject;
    private Color connectorColor;

    public ConnectorBorder(IInterfaceElement editPartModelOject) {
        this.editPartModelOject = editPartModelOject;
        this.updateColor();
    }

    public final void updateColor() {
        this.connectorColor = this.isEvent() ? PreferenceGetter.getColor((String)"EventConnectionConnectorColor") : (this.isAdapter() ? PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor") : PreferenceGetter.getDataColor((String)this.editPartModelOject.getType().getName()));
    }

    protected static void createAdapterSymbolMiniFBrotated(Graphics graphics, Rectangle where, int width, boolean filled) {
        graphics.setLineWidth(1);
        graphics.setAntialias(1);
        where.x += width;
        where.y += (where.height - 9) / 2;
        PointList points = new PointList();
        points.addPoint(where.x, where.y);
        if (filled) {
            points.addPoint(where.x + 2, where.y);
            points.addPoint(where.x + 2, where.y + 2);
            points.addPoint(where.x + 4, where.y + 2);
            points.addPoint(where.x + 4, where.y);
            points.addPoint(where.x + 8, where.y);
            points.addPoint(where.x + 8, where.y + 8);
            points.addPoint(where.x + 4, where.y + 8);
            points.addPoint(where.x + 4, where.y + 6);
            points.addPoint(where.x + 2, where.y + 6);
            points.addPoint(where.x + 2, where.y + 8);
            points.addPoint(where.x, where.y + 8);
            points.addPoint(where.x, where.y);
            graphics.fillPolygon(points);
        } else {
            points.addPoint(where.x + 4, where.y);
            points.addPoint(where.x + 4, where.y + 2);
            points.addPoint(where.x + 6, where.y + 2);
            points.addPoint(where.x + 6, where.y);
            points.addPoint(where.x + 8, where.y);
            points.addPoint(where.x + 8, where.y + 8);
            points.addPoint(where.x + 6, where.y + 8);
            points.addPoint(where.x + 6, where.y + 6);
            points.addPoint(where.x + 4, where.y + 6);
            points.addPoint(where.x + 4, where.y + 8);
            points.addPoint(where.x, where.y + 8);
            points.addPoint(where.x, where.y);
            graphics.drawPolygon(points);
        }
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setForegroundColor(this.connectorColor);
        graphics.setBackgroundColor(this.connectorColor);
        Rectangle where = ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        Rectangle r = null;
        if (this.isInput()) {
            if (this.isAdapter()) {
                ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, 0, false);
            } else {
                r = new Rectangle(where.x, where.y + (where.height - 5) / 2, 5, 5);
                graphics.fillRectangle(r);
            }
        } else if (this.isAdapter()) {
            ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, where.width - 9 + 1, true);
        } else {
            r = new Rectangle(where.width + where.x - 5, where.y + (where.height - 5) / 2, 5, 5);
            graphics.fillRectangle(r);
        }
    }

    public Insets getInsets(IFigure figure) {
        int lrMargin = this.isAdapter() ? 11 : 6;
        return new Insets(0, lrMargin, 0, lrMargin);
    }

    public boolean isInput() {
        return this.editPartModelOject.isIsInput();
    }

    public final boolean isEvent() {
        return this.editPartModelOject.getType() instanceof EventType;
    }

    public final boolean isAdapter() {
        return this.editPartModelOject.getType() instanceof AdapterType;
    }
}

