/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import java.text.MessageFormat;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.commands.Command;

public class AdjustConnectionCommand
extends Command {
    private final Connection connection;
    private final Point point;
    private final int index;
    private final org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection;
    private final double zoom;
    private final ConnectionRoutingData oldRoutingData;
    private ConnectionRoutingData newRoutingData;

    public AdjustConnectionCommand(Connection connection, Point p, int index, org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection, double zoom) {
        this.connection = connection;
        this.point = p;
        this.index = index;
        this.modelConnection = modelConnection;
        this.zoom = zoom;
        this.oldRoutingData = modelConnection.getRoutingData();
    }

    public void execute() {
        this.createInitalNewRoutingData();
        this.updateNewRoutingData();
        this.updateRoutingData(this.newRoutingData);
    }

    public void undo() {
        this.updateRoutingData(this.oldRoutingData);
    }

    public void redo() {
        this.updateRoutingData(this.newRoutingData);
    }

    private void updateRoutingData(ConnectionRoutingData routingData) {
        this.modelConnection.setRoutingData(routingData);
        this.connection.revalidate();
    }

    private void updateNewRoutingData() {
        Point sourceP = this.getSourcePoint();
        Point destP = this.getDestinationPoint();
        int scaledMinDistance = (int)Math.floor(12.0 * this.zoom);
        switch (this.index) {
            case 1: {
                int newDx1 = Math.max(this.point.x - sourceP.x, scaledMinDistance);
                if (this.newRoutingData.getDx2() == 0) {
                    newDx1 = Math.min(newDx1, destP.x - sourceP.x - scaledMinDistance);
                }
                this.newRoutingData.setDx1((int)Math.floor((double)newDx1 / this.zoom));
                break;
            }
            case 2: {
                this.newRoutingData.setDy((int)Math.floor((double)(this.point.y - sourceP.y) / this.zoom));
                break;
            }
            case 3: {
                int newDx2 = Math.max(destP.x - this.point.x, scaledMinDistance);
                this.newRoutingData.setDx2((int)Math.floor((double)newDx2 / this.zoom));
                break;
            }
            default: {
                Activator.getDefault().logError(MessageFormat.format(Messages.AdjustConnectionCommand_WrongConnectionSegmentIndex, this.index));
            }
        }
    }

    private void createInitalNewRoutingData() {
        this.newRoutingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        this.newRoutingData.setDx1(this.oldRoutingData.getDx1());
        this.newRoutingData.setDx2(this.oldRoutingData.getDx2());
        this.newRoutingData.setDy(this.oldRoutingData.getDy());
    }

    private Point getDestinationPoint() {
        return this.connection.getTargetAnchor().getLocation(this.connection.getTargetAnchor().getReferencePoint()).getCopy();
    }

    private Point getSourcePoint() {
        return this.connection.getSourceAnchor().getLocation(this.connection.getSourceAnchor().getReferencePoint()).getCopy();
    }
}

