/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.DiagramOutlinePage;
import org.eclipse.fordiac.ide.gef.MouseWheelZoomHandler;
import org.eclipse.fordiac.ide.gef.dnd.ParameterDropTargetListener;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.handlers.AdvancedGraphicalViewerKeyHandler;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.FigureFontUpdateListener;
import org.eclipse.fordiac.ide.gef.print.PrintPreviewAction;
import org.eclipse.fordiac.ide.gef.ruler.FordiacRulerComposite;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.ui.editors.I4diacModelEditor;
import org.eclipse.fordiac.ide.util.UntypedEditorInput;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class DiagramEditorWithFlyoutPalette
extends GraphicalEditorWithFlyoutPalette
implements ITabbedPropertySheetPageContributor,
I4diacModelEditor {
    public static final String PROPERTY_CONTRIBUTOR_ID = "org.eclipse.fordiac.ide.application.editors.DiagramEditor";
    private KeyHandler sharedKeyHandler;
    private DiagramOutlinePage outlinePage;
    private RulerComposite rulerComp;

    public CommandStack getCommandStack() {
        return super.getCommandStack();
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public void setFocus() {
        super.setFocus();
        for (Object element : this.getGraphicalViewer().getRootEditPart().getChildren()) {
            EditPart ep = (EditPart)element;
            ep.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer.getControl() instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)viewer.getControl();
            Display.getDefault().asyncExec(() -> {
                viewer.flush();
                if (viewer.getSelectedEditParts().isEmpty()) {
                    Point scrollPos = this.getInitialScrollPos();
                    canvas.scrollTo(scrollPos.x, scrollPos.y);
                } else {
                    viewer.revealEditPart((EditPart)viewer.getSelectedEditParts().get(0));
                }
            });
        }
    }

    protected Point getInitialScrollPos() {
        FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getGraphicalViewer().getRootEditPart();
        Rectangle drawingAreaBounds = rootEditPart.getContentPane().getBounds();
        return new Point(drawingAreaBounds.x - 5, drawingAreaBounds.y - 5);
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new FordiacRulerComposite(parent, 0);
        AdvancedScrollingGraphicalViewer viewer = new AdvancedScrollingGraphicalViewer();
        viewer.createControl((Composite)this.rulerComp);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        FigureFontUpdateListener rootFigureListener = new FigureFontUpdateListener(((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getFigure(), "org.eclipse.fordiac.ide.preferences.diagramFontDefinition");
        DiagramFontChangeListener fontChangeListener = new DiagramFontChangeListener(rootFigureListener);
        rootFigureListener.updateFonts();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)fontChangeListener);
        viewer.getControl().addDisposeListener(e -> JFaceResources.getFontRegistry().removeListener(fontChangeListener));
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected Control getGraphicalControl() {
        return this.rulerComp;
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = this.createRootEditPart();
        ContextMenuProvider cmp = this.getContextMenuProvider((ScrollingGraphicalViewer)viewer, root.getZoomManager());
        if (cmp != null) {
            viewer.setContextMenu((MenuManager)cmp);
            this.getSite().registerContextMenu("org.eclipse.fordiac.ide.gef.contextmenu", (MenuManager)cmp, (ISelectionProvider)viewer);
        }
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.getEditPartFactory());
        AdvancedGraphicalViewerKeyHandler keyHandler = new AdvancedGraphicalViewerKeyHandler(viewer);
        keyHandler.setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler((KeyHandler)keyHandler);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public ZoomManager getZoomManger() {
        return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected abstract EditPartFactory getEditPartFactory();

    protected abstract ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer var1, ZoomManager var2);

    protected abstract org.eclipse.jface.util.TransferDropTargetListener createTransferDropTargetListener();

    protected void initializeGraphicalViewer() {
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents(this.getModel());
        org.eclipse.jface.util.TransferDropTargetListener listener = this.createTransferDropTargetListener();
        if (listener != null) {
            viewer.addDropTargetListener(listener);
        }
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        viewer.addDropTargetListener((TransferDropTargetListener)new ParameterDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setModel(input);
        super.init(site, input);
        this.setEditorPartName(input);
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    protected void setEditorPartName(IEditorInput input) {
        if (input.getName() != null) {
            this.setPartName(input.getName());
        }
    }

    protected void updateEditorTitle(String newTitle) {
        ((UntypedEditorInput)this.getEditorInput()).setName(newTitle);
        this.setPartName(newTitle);
    }

    protected void setModel(IEditorInput input) {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getEditDomain().setDefaultTool((Tool)this.createDefaultTool());
        this.getEditDomain().setActiveTool(this.getEditDomain().getDefaultTool());
        if (this.getSystem() != null) {
            this.getEditDomain().setCommandStack(this.getSystem().getCommandStack());
        }
    }

    protected AdvancedPanningSelectionTool createDefaultTool() {
        return new AdvancedPanningSelectionTool();
    }

    public abstract AutomationSystem getSystem();

    public abstract void doSave(IProgressMonitor var1);

    public abstract void doSaveAs();

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (type == IContentOutlinePage.class) {
            this.outlinePage = new DiagramOutlinePage((GraphicalViewer)this.getGraphicalViewer());
            return this.outlinePage;
        }
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        super.createActions();
        registry.removeAction(registry.getAction((Object)ActionFactory.PRINT.getId()));
        action = new PrintPreviewAction((GraphicalViewer)this.getGraphicalViewer());
        registry.registerAction((IAction)action);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)action);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    public List getSelActions() {
        return this.getSelectionActions();
    }

    public void dispose() {
        this.outlinePage = null;
        super.dispose();
    }

    public AdvancedScrollingGraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public String getContributorId() {
        return PROPERTY_CONTRIBUTOR_ID;
    }

    protected AdvancedScrollingGraphicalViewer getGraphicalViewer() {
        return (AdvancedScrollingGraphicalViewer)super.getGraphicalViewer();
    }
}

