/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.views;

import java.util.ArrayDeque;
import java.util.StringTokenizer;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.views.WatchValueTreeNode;

public final class StructParser {
    public static WatchValueTreeNode createStructFromString(String struct, StructuredType structType, MonitoringElement monitoringElement, WatchValueTreeNode parent) {
        WatchValueTreeNode structRoot;
        if (!struct.isEmpty()) {
            struct = struct.substring(1, struct.length() - 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(struct, ",");
        IInterfaceElement interfaceElement = monitoringElement.getPort().getInterfaceElement();
        interfaceElement.getName();
        WatchValueTreeNode previous = structRoot = new WatchValueTreeNode(monitoringElement, structType, interfaceElement.getName(), "root", null, parent);
        ArrayDeque<WatchValueTreeNode> structParentLevelStack = new ArrayDeque<WatchValueTreeNode>();
        structParentLevelStack.push(structRoot);
        while (tokenizer.hasMoreTokens()) {
            WatchValueTreeNode newNode;
            String nextToken = tokenizer.nextToken();
            String[] parsedAssignment = StructParser.parseAssignment(nextToken, previous);
            if ("".equals(parsedAssignment[0])) continue;
            String varName = parsedAssignment[0];
            String value = parsedAssignment[1];
            VarDeclaration varDeclaration = StructParser.findVarDeclaration(structType, varName);
            previous = newNode = new WatchValueTreeNode(monitoringElement, structType, varName, value, varDeclaration, (WatchValueTreeNode)((Object)structParentLevelStack.peek()));
            ((WatchValueTreeNode)((Object)structParentLevelStack.peek())).addChild(newNode);
            if (value.charAt(0) == '(') {
                structParentLevelStack.push(newNode);
            }
            if (value.charAt(value.length() - 1) != ')') continue;
            newNode.setValue(value.substring(0, value.length() - 1));
            structParentLevelStack.pop();
        }
        return structRoot;
    }

    private static VarDeclaration findVarDeclaration(StructuredType structType, String varName) {
        return structType.getMemberVariables().stream().filter(variable -> variable.getName().equals(varName)).findAny().orElse(null);
    }

    private static String[] parseAssignment(String assignment, WatchValueTreeNode previous) {
        if (assignment.contains(":=")) {
            String[] splittedAssignment = assignment.split(":=", 2);
            String variableName = splittedAssignment[0];
            String value = splittedAssignment[1];
            return new String[]{variableName, value};
        }
        StringBuilder newValueBuilder = new StringBuilder();
        String value = "null";
        if (previous != null) {
            value = previous.getValue();
        }
        newValueBuilder.append(value);
        newValueBuilder.append(assignment);
        if (previous != null) {
            previous.setValue(newValueBuilder.toString());
        }
        return new String[]{"", ""};
    }

    public static void buildTree(StructuredType structType, WatchValueTreeNode parent, MonitoringBaseElement element) {
        for (VarDeclaration memberVariable : structType.getMemberVariables()) {
            WatchValueTreeNode treeNode = (WatchValueTreeNode)parent.addChild(memberVariable, element, structType);
            if (!(memberVariable.getType() instanceof StructuredType) || memberVariable.getType() == IecTypes.GenericTypes.ANY_STRUCT) continue;
            StructParser.buildTree((StructuredType)memberVariable.getType(), treeNode, element);
        }
    }

    private StructParser() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

