/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.model;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.MonitoringManagerUtils;

public final class SubAppPortHelper {
    public static IInterfaceElement findAnchorInterfaceElement(IInterfaceElement subappPin) {
        boolean isInput = subappPin.isIsInput();
        if (SubAppPortHelper.hasEmptyConnections(subappPin, isInput)) {
            return null;
        }
        IInterfaceElement current = subappPin;
        while (current.getFBNetworkElement() instanceof SubApp) {
            EList<Connection> outConns = SubAppPortHelper.getConnections(current, isInput);
            if (outConns.isEmpty()) {
                return null;
            }
            current = SubAppPortHelper.assignNextInterfaceElement(isInput, outConns);
        }
        return current;
    }

    public static String findConnectedMonitoredSubappPort(IInterfaceElement interfaceElement, Map<String, List<MonitoringElement>> subappElements) {
        boolean searchDirection;
        boolean bl = searchDirection = !interfaceElement.isIsInput();
        do {
            EList<Connection> connections;
            if ((connections = SubAppPortHelper.getConnections(interfaceElement, searchDirection)).isEmpty()) {
                return null;
            }
            interfaceElement = SubAppPortHelper.assignNextInterfaceElement(searchDirection, connections);
            if (!interfaceElement.getFBNetworkElement().isMapped()) {
                return null;
            }
            PortElement subappPortCanidate = MonitoringManagerUtils.createPortElement(interfaceElement.getFBNetworkElement(), interfaceElement);
            String anchor = SubAppPortHelper.searchSubappAnchor(subappElements, subappPortCanidate);
            if (!subappElements.containsKey(anchor)) continue;
            return anchor;
        } while (interfaceElement.getFBNetworkElement() instanceof SubApp);
        return null;
    }

    public static IInterfaceElement assignNextInterfaceElement(boolean isInput, List<Connection> connections) {
        Connection connection = connections.get(0);
        return isInput ? connection.getDestination() : connection.getSource();
    }

    public static boolean hasEmptyConnections(IInterfaceElement ie, boolean isInput) {
        EList<Connection> connections = SubAppPortHelper.getConnections(ie, isInput);
        return connections.isEmpty();
    }

    public static EList<Connection> getConnections(IInterfaceElement ie, boolean isInput) {
        return isInput ? ie.getOutputConnections() : ie.getInputConnections();
    }

    public static String searchSubappAnchor(Map<String, List<MonitoringElement>> subappElements, PortElement createPortElement) {
        MonitoringBaseElement monitoringElement = MonitoringManager.getInstance().getMonitoringElement(createPortElement.getInterfaceElement());
        if (!(monitoringElement instanceof SubappMonitoringElement)) {
            return "";
        }
        MonitoringBaseElement anchor = ((SubappMonitoringElement)monitoringElement).getAnchor();
        return anchor.getPort().getPortString();
    }

    private SubAppPortHelper() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

