/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.editparts;

import java.util.ArrayList;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.SpecificLayerEditPart;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringAdapterEditPart;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public abstract class AbstractMonitoringBaseEditPart
extends AbstractViewEditPart
implements SpecificLayerEditPart {
    private InterfaceEditPart parentPart;
    private IPropertyChangeListener listener;
    private static int maxLabelWidth = -1;

    public void activate() {
        super.activate();
        for (Object object : this.getViewer().getEditPartRegistry().keySet()) {
            EditPart part;
            if (!(object instanceof IInterfaceElement)) continue;
            IInterfaceElement interfaceElement = (IInterfaceElement)object;
            if (interfaceElement.equals(this.getInterfaceElement())) {
                EditPart part2 = (EditPart)this.getViewer().getEditPartRegistry().get(object);
                if (!(part2 instanceof InterfaceEditPart)) continue;
                this.parentPart = (InterfaceEditPart)part2;
                IFigure f = this.parentPart.getFigure();
                f.addAncestorListener(new AncestorListener(){

                    public void ancestorRemoved(IFigure ancestor) {
                    }

                    public void ancestorMoved(IFigure ancestor) {
                        AbstractMonitoringBaseEditPart.this.refreshVisuals();
                    }

                    public void ancestorAdded(IFigure ancestor) {
                    }
                });
                continue;
            }
            if (!(interfaceElement instanceof AdapterDeclaration)) continue;
            IInterfaceElement subInterfaceElement = null;
            InterfaceList interfaceList = ((AdapterDeclaration)interfaceElement).getType().getInterfaceList();
            ArrayList list = new ArrayList();
            list.addAll(interfaceList.getEventInputs());
            list.addAll(interfaceList.getEventOutputs());
            list.addAll(interfaceList.getInputVars());
            list.addAll(interfaceList.getOutputVars());
            for (IInterfaceElement element : list) {
                if (!element.equals(this.getInterfaceElement()) || interfaceElement.eContainer().eContainer() != this.getModel().getPort().getFb()) continue;
                subInterfaceElement = element;
                break;
            }
            if (subInterfaceElement == null) continue;
            Object subObject = null;
            for (Object obj : this.getViewer().getEditPartRegistry().values()) {
                MonitoringAdapterEditPart part3;
                if (!(obj instanceof MonitoringAdapterEditPart) || (part3 = (MonitoringAdapterEditPart)((Object)obj)).getModel().getPort().getInterfaceElement() != interfaceElement) continue;
                for (Object subView : part3.getModelChildren()) {
                    if (!((IInterfaceElement)subView).getName().equals(subInterfaceElement.getName())) continue;
                    subObject = subView;
                    break;
                }
                if (subObject != null) break;
            }
            if (subObject == null || !((part = (EditPart)this.getViewer().getEditPartRegistry().get(subObject)) instanceof InterfaceEditPart)) continue;
            this.parentPart = (InterfaceEditPart)part;
            IFigure f = this.parentPart.getFigure();
            f.addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    AbstractMonitoringBaseEditPart.this.refreshVisuals();
                }

                public void ancestorAdded(IFigure ancestor) {
                }
            });
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferenceChangeListener());
        this.refreshVisuals();
    }

    public INamedElement getINamedElement() {
        return this.getInterfaceElement();
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = event -> {
                if (event.getProperty().equals("watchColor") || event.getProperty().equals("forceColor")) {
                    this.setBackgroundColor(this.getFigure());
                }
            };
        }
        return this.listener;
    }

    public String getSpecificLayer() {
        return "TOPLAYER";
    }

    public MonitoringBaseElement getModel() {
        return (MonitoringBaseElement)super.getModel();
    }

    public boolean understandsRequest(Request request) {
        if (request.getType() == "move") {
            return false;
        }
        return super.understandsRequest(request);
    }

    private Point calculatePos() {
        if (this.parentPart != null) {
            Rectangle bounds = this.parentPart.getFigure().getBounds();
            int x = 0;
            if (this.isInput()) {
                int width = this.calculateWidth();
                x = bounds.x - 2 - width;
            } else {
                x = bounds.x + bounds.width + 2;
            }
            int y = bounds.y;
            return new Point(x, y);
        }
        return new Point(0, 0);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
        this.setBackgroundColor(this.getFigure());
        this.getFigure().setEnabled(!this.getModel().isOffline());
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            int width = this.calculateWidth();
            bounds = new Rectangle(p.x, p.y, width, -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        }
    }

    protected void setBackgroundColor(IFigure l) {
        l.setBackgroundColor(PreferenceGetter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"watchColor"));
    }

    protected void backgroundColorChanged(IFigure figure) {
        this.setBackgroundColor(figure);
    }

    protected boolean isInput() {
        return this.getInterfaceElement().isIsInput();
    }

    protected IInterfaceElement getInterfaceElement() {
        return this.getModel().getPort().getInterfaceElement();
    }

    private int calculateWidth() {
        int width = this.getFigure().getPreferredSize().width;
        width = Math.max(40, width);
        width = Math.min(width, AbstractMonitoringBaseEditPart.getMaxWidth());
        return width;
    }

    private static int getMaxWidth() {
        if (maxLabelWidth == -1) {
            IPreferenceStore preferenceStore = org.eclipse.fordiac.ide.gef.Activator.getDefault().getPreferenceStore();
            int maxLabelSize = preferenceStore.getInt("MaxValueLabelSize");
            FontMetrics fm = FigureUtilities.getFontMetrics((Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
            maxLabelWidth = (int)((double)maxLabelSize * fm.getAverageCharacterWidth());
        }
        return maxLabelWidth;
    }
}

