/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.SubAppPortElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.DeviceMonitoringHandler;
import org.eclipse.fordiac.ide.monitoring.DisableSystemMonitoringRunnable;
import org.eclipse.fordiac.ide.monitoring.EnableSystemMonitoringRunnable;
import org.eclipse.fordiac.ide.monitoring.model.SubAppPortHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemMonitoringData {
    private final AutomationSystem system;
    private final Map<IInterfaceElement, MonitoringBaseElement> monitoredElements = new HashMap<IInterfaceElement, MonitoringBaseElement>();
    private final Map<String, MonitoringBaseElement> monitoredElementsPerPortStrings = new HashMap<String, MonitoringBaseElement>();
    private final Map<String, List<MonitoringElement>> subappElements = new HashMap<String, List<MonitoringElement>>();
    private final Map<Device, DeviceMonitoringHandler> deviceHandlers = new HashMap<Device, DeviceMonitoringHandler>();

    public Map<String, List<MonitoringElement>> getSubappElements() {
        return this.subappElements;
    }

    public SystemMonitoringData(AutomationSystem system) {
        this.system = system;
    }

    AutomationSystem getSystem() {
        return this.system;
    }

    Collection<MonitoringBaseElement> getMonitoredElements() {
        return this.monitoredElements.values();
    }

    DeviceMonitoringHandler getDevMonitoringHandler(Device dev) {
        return this.deviceHandlers.get(dev);
    }

    void addDevMonitoringHandler(Device dev, DeviceMonitoringHandler handler) {
        this.deviceHandlers.put(dev, handler);
    }

    Map<Device, DeviceMonitoringHandler> getDevMonitoringHandlers() {
        return this.deviceHandlers;
    }

    void removeDeviceMonitoringHandler(Device dev) {
        this.deviceHandlers.remove(dev);
    }

    public void enableSystem() {
        EnableSystemMonitoringRunnable enable = new EnableSystemMonitoringRunnable(this);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, (IRunnableWithProgress)enable);
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            MessageDialog.openInformation((Shell)shell, (String)"Enable Monitoring Aborted", (String)"Enable Monitoring Aborted");
        }
    }

    public void enableSystemSynch(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EnableSystemMonitoringRunnable enable = new EnableSystemMonitoringRunnable(this);
        enable.run(monitor);
    }

    public void disableSystem() {
        DisableSystemMonitoringRunnable disable = new DisableSystemMonitoringRunnable(this);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)disable);
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            MessageDialog.openInformation((Shell)shell, (String)"Disable Monitoring Aborted", (String)"Disable Monitoring Aborted");
        }
    }

    public void disableSystemSynch(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DisableSystemMonitoringRunnable disable = new DisableSystemMonitoringRunnable(this);
        disable.run(monitor);
    }

    public MonitoringBaseElement getMonitoringElementByPortString(String portString) {
        return this.monitoredElementsPerPortStrings.get(portString);
    }

    public void sendRemoveWatch(MonitoringBaseElement element) {
        IDeviceManagementInteractor devMgmInteractor = this.getDevMgmInteractor(element.getPort().getDevice());
        if (devMgmInteractor != null && devMgmInteractor.isConnected()) {
            try {
                devMgmInteractor.removeWatch(element);
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not remove watch for " + element.getQualifiedString(), (Exception)((Object)e));
            }
        }
    }

    public void sendAddWatch(MonitoringBaseElement element) {
        IDeviceManagementInteractor devMgmInteractor = this.getDevMgmInteractor(element.getPort().getDevice());
        if (devMgmInteractor != null && devMgmInteractor.isConnected()) {
            try {
                devMgmInteractor.addWatch(element);
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not add watch for " + element.getQualifiedString(), (Exception)((Object)e));
            }
        }
    }

    public IDeviceManagementInteractor getDevMgmInteractor(Device device) {
        DeviceMonitoringHandler handler = this.getDevMonitoringHandler(device);
        return handler != null ? handler.getDevMgmInteractor() : null;
    }

    public void removeMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        if (element instanceof MonitoringElement) {
            this.sendRemoveWatch(element);
        }
        this.monitoredElements.remove(port.getInterfaceElement());
        this.monitoredElementsPerPortStrings.remove(port.getPortString());
        this.handleSubappElements(element, port);
    }

    public void handleSubappElements(MonitoringBaseElement element, PortElement port) {
        if (this.subappElements.containsKey(port.getPortString())) {
            this.removeSubappElement(element, port.getPortString());
        }
        if (element instanceof SubappMonitoringElement) {
            this.removeSubappElement(element, ((SubappMonitoringElement)element).getAnchor().getPort().getPortString());
        }
    }

    public void removeSubappElement(MonitoringBaseElement element, String portString) {
        if (this.subappElements.containsKey(portString)) {
            List<MonitoringElement> subappPins = this.subappElements.get(portString);
            boolean remove = subappPins.remove(element);
            Assert.isTrue((boolean)remove);
            if (subappPins.isEmpty()) {
                this.subappElements.remove(portString);
            }
        }
    }

    public void addMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        this.monitoredElements.put(port.getInterfaceElement(), element);
        if (port instanceof SubAppPortElement) {
            this.addSubappMonitoringElement(element);
        } else {
            this.checkForSubappGroup(element, port);
            this.handleConnectedSubappPorts(element);
            this.monitoredElementsPerPortStrings.put(port.getPortString(), element);
        }
        if (element instanceof MonitoringElement) {
            this.sendAddWatch(element);
        }
    }

    public void addSubappMonitoringElement(MonitoringBaseElement element) {
        PortElement anchor = ((SubappMonitoringElement)element).getAnchor().getPort();
        String portString = anchor.getPortString();
        if (this.subappElements.containsKey(portString)) {
            List<MonitoringElement> subappPins = this.subappElements.get(portString);
            subappPins.add((MonitoringElement)element);
        } else {
            this.createNewSubappGroup(element, portString);
        }
    }

    public void checkForSubappGroup(MonitoringBaseElement element, PortElement port) {
        if (this.subappElements.containsKey(port.getPortString())) {
            List<MonitoringElement> subappPins = this.subappElements.get(port.getPortString());
            subappPins.add((MonitoringElement)element);
        }
    }

    public void createNewSubappGroup(MonitoringBaseElement element, String portString) {
        ArrayList<MonitoringElement> l = new ArrayList<MonitoringElement>();
        l.add((SubappMonitoringElement)element);
        this.subappElements.put(portString, l);
        this.addExistingElementToSubappGroup(portString, l);
    }

    public void addExistingElementToSubappGroup(String portString, List<MonitoringElement> l) {
        MonitoringBaseElement monitoringBaseElement = this.monitoredElementsPerPortStrings.get(portString);
        if (monitoringBaseElement != null) {
            l.add((MonitoringElement)monitoringBaseElement);
        }
    }

    private void handleConnectedSubappPorts(MonitoringBaseElement element) {
        List<MonitoringElement> list;
        FBNetworkElement fb = element.getPort().getFb();
        if (!fb.isNestedInSubApp()) {
            return;
        }
        IInterfaceElement interfaceElement = element.getPort().getInterfaceElement();
        String findConnectedMonitoredSubappPort = SubAppPortHelper.findConnectedMonitoredSubappPort(interfaceElement, this.subappElements);
        if (findConnectedMonitoredSubappPort != null && !(list = this.subappElements.get(findConnectedMonitoredSubappPort)).contains(element)) {
            list.add((MonitoringElement)element);
        }
    }

    public MonitoringBaseElement getMonitoredElement(IInterfaceElement port) {
        return this.monitoredElements.get(port);
    }

    public Map.Entry<String, List<MonitoringElement>> getSubappElements(MonitoringBaseElement m) {
        for (Map.Entry<String, List<MonitoringElement>> e : this.getSubappElements().entrySet()) {
            List<MonitoringElement> l = e.getValue();
            for (MonitoringElement me : l) {
                if (!me.equals(m)) continue;
                return e;
            }
        }
        return null;
    }
}

