/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseFactory;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.monitoring.AdapterPortElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.model.monitoring.SubAppPortElement;
import org.eclipse.fordiac.ide.monitoring.Messages;
import org.eclipse.fordiac.ide.monitoring.model.SubAppPortHelper;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;

public final class MonitoringManagerUtils {
    private MonitoringManagerUtils() {
        throw new AssertionError();
    }

    public static boolean canBeMonitored(IInterfaceElement ie, boolean showError) {
        FBNetworkElement fbNetworkElement = ie.getFBNetworkElement();
        if (fbNetworkElement instanceof SubApp) {
            IInterfaceElement anchor = SubAppPortHelper.findAnchorInterfaceElement(ie);
            if (anchor == null) {
                if (showError) {
                    ErrorMessenger.popUpErrorMessage((String)Messages.MonitoringManagerUtils_NoSubappAnchor);
                }
            } else {
                MonitoringManagerUtils.canBeMonitored(anchor, false);
            }
        }
        return fbNetworkElement != null && fbNetworkElement.getResource() != null;
    }

    public static boolean canBeMonitored(FBNetworkElement obj) {
        EList ies = obj.getInterface().getAllInterfaceElements();
        return !ies.isEmpty() && MonitoringManagerUtils.canBeMonitored((IInterfaceElement)ies.get(0), false);
    }

    public static PortElement createPortElement(IInterfaceElement ie) {
        FBNetworkElement obj = ie.getFBNetworkElement();
        if (obj instanceof FB || obj instanceof SubApp) {
            return MonitoringManagerUtils.createPortElement(obj, ie);
        }
        return null;
    }

    public static PortElement createPortElement(FBNetworkElement fb, IInterfaceElement ie) {
        AdapterPortElement p = ie instanceof AdapterDeclaration ? MonitoringFactory.eINSTANCE.createAdapterPortElement() : (fb instanceof SubApp ? MonitoringManagerUtils.createrSubAppPort(ie) : MonitoringBaseFactory.eINSTANCE.createPortElement());
        Resource res = fb.getResource();
        if (res == null) {
            return null;
        }
        p.setResource(res);
        if (fb instanceof FB || fb instanceof SubApp) {
            p.setFb(fb);
        }
        MonitoringManagerUtils.setupFBHierarchy(fb, p);
        p.setInterfaceElement(ie);
        return p;
    }

    public static PortElement createrSubAppPort(IInterfaceElement ie) {
        SubAppPortElement subAppPort = MonitoringFactory.eINSTANCE.createSubAppPortElement();
        IInterfaceElement anchor = SubAppPortHelper.findAnchorInterfaceElement(ie);
        subAppPort.setAnchor(anchor);
        return subAppPort;
    }

    private static void setupFBHierarchy(FBNetworkElement element, PortElement p) {
        if (!element.isMapped() && element.getFbNetwork().eContainer() instanceof SubApp) {
            SubApp subApp = (SubApp)element.getFbNetwork().eContainer();
            MonitoringManagerUtils.setupFBHierarchy((FBNetworkElement)subApp, p);
            p.getHierarchy().add((Object)subApp.getName());
        }
    }
}

