/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.AbstractMonitoringManager;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MonitoringManager
extends AbstractMonitoringManager {
    private final Map<AutomationSystem, SystemMonitoringData> systemMonitoringData = new HashMap<AutomationSystem, SystemMonitoringData>();

    public static MonitoringManager getInstance() {
        return (MonitoringManager)AbstractMonitoringManager.getMonitoringManager();
    }

    public MonitoringBaseElement getMonitoringElement(IInterfaceElement port) {
        SystemMonitoringData data;
        AutomationSystem sys = MonitoringManager.getAutomationSystem(port);
        if (sys != null && (data = this.systemMonitoringData.get(sys)) != null) {
            return data.getMonitoredElement(port);
        }
        return null;
    }

    private static AutomationSystem getAutomationSystem(IInterfaceElement port) {
        FBNetworkElement fbNetworkElement;
        if (port != null && (fbNetworkElement = port.getFBNetworkElement()) != null) {
            if (fbNetworkElement instanceof AdapterFB) {
                return MonitoringManager.getAutomationSystem((IInterfaceElement)((AdapterFB)fbNetworkElement).getAdapterDecl());
            }
            return fbNetworkElement.getFbNetwork().getAutomationSystem();
        }
        return null;
    }

    public void addMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        SystemMonitoringData data = this.getSystemMonitoringData(port.getSystem());
        data.addMonitoringElement(element);
        this.notifyAddPort(port);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortAdded(port);
        }
    }

    public void removeMonitoringElement(MonitoringBaseElement element) {
        SystemMonitoringData data = this.getSystemMonitoringData(element.getPort().getSystem());
        data.removeMonitoringElement(element);
        if (element instanceof MonitoringElement) {
            this.notifyWatchesAdapterPortRemoved(element.getPort());
        }
        this.notifyRemovePort(element.getPort());
    }

    public boolean containsPort(IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            return this.getMonitoringElement(interfaceElement) != null;
        }
        return false;
    }

    public Collection<MonitoringBaseElement> getAllElementsToMonitor() {
        ArrayList<MonitoringBaseElement> elements = new ArrayList<MonitoringBaseElement>();
        for (SystemMonitoringData data : this.systemMonitoringData.values()) {
            elements.addAll(data.getMonitoredElements());
        }
        return elements;
    }

    public Collection<MonitoringBaseElement> getElementsToMonitor(AutomationSystem sys) {
        SystemMonitoringData sysData;
        if (sys != null && (sysData = this.systemMonitoringData.get(sys)) != null) {
            return sysData.getMonitoredElements();
        }
        return Collections.emptyList();
    }

    public void enableSystem(AutomationSystem system) {
        this.getSystemMonitoringData(system).enableSystem();
    }

    public void enableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getSystemMonitoringData(system).enableSystemSynch(monitor);
    }

    public void disableSystem(AutomationSystem system) {
        SystemMonitoringData data = this.systemMonitoringData.remove(system);
        this.notifyWatchesChanged();
        if (data != null) {
            data.disableSystem();
        }
    }

    public void disableSystemSynch(AutomationSystem system, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SystemMonitoringData data = this.systemMonitoringData.remove(system);
        if (data != null) {
            data.disableSystemSynch(monitor);
        }
    }

    public boolean isSystemMonitored(AutomationSystem system) {
        return this.systemMonitoringData.containsKey(system);
    }

    public Set<AutomationSystem> getMonitoredSystems() {
        return this.systemMonitoringData.keySet();
    }

    public void triggerEvent(IInterfaceElement interfaceElement) {
        MonitoringBaseElement element = this.getMonitoringElement(interfaceElement);
        if (element instanceof MonitoringElement) {
            SystemMonitoringData data;
            IDeviceManagementInteractor devMgmInteractor;
            MonitoringElement monitoringElement = (MonitoringElement)element;
            if (element instanceof SubappMonitoringElement) {
                monitoringElement = (MonitoringElement)((SubappMonitoringElement)monitoringElement).getAnchor();
            }
            if ((devMgmInteractor = (data = this.getSystemMonitoringData(monitoringElement.getPort().getSystem())).getDevMgmInteractor(monitoringElement.getPort().getDevice())) != null) {
                try {
                    devMgmInteractor.triggerEvent((MonitoringBaseElement)monitoringElement);
                }
                catch (DeploymentException e) {
                    Activator.getDefault().logError("Could not trigger event for " + element.getQualifiedString(), (Exception)((Object)e));
                }
                this.notifyTriggerEvent(monitoringElement.getPort());
            }
        }
    }

    public void writeValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            MonitoringManager.showSystemNotFoundErrorMsg(element);
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            MonitoringManager.showDeviceNotFounderroMsg(element);
            return;
        }
        SystemMonitoringData data = this.getSystemMonitoringData(automationSystem);
        IDeviceManagementInteractor devMgmInteractor = data.getDevMgmInteractor(device);
        if (devMgmInteractor != null) {
            MonitoringManager.writeElements(element, value, data, devMgmInteractor);
        }
    }

    public static void writeElements(MonitoringElement element, String value, SystemMonitoringData data, IDeviceManagementInteractor devMgmInteractor) {
        ArrayList<MonitoringElement> elements = new ArrayList<MonitoringElement>();
        if (element instanceof SubappMonitoringElement) {
            MonitoringManager.handleSubappPinWrite(element, data, elements);
        } else {
            elements.add(element);
        }
        for (MonitoringElement e : elements) {
            String fullName = e.getQualifiedString();
            fullName = fullName.substring(0, fullName.lastIndexOf(46));
            fullName = fullName.substring(0, fullName.lastIndexOf(46) + 1);
            FBDeploymentData d = new FBDeploymentData(fullName, e.getPort().getFb());
            try {
                devMgmInteractor.writeFBParameter(e.getPort().getResource(), value, d, (VarDeclaration)e.getPort().getInterfaceElement());
            }
            catch (DeploymentException ex) {
                Activator.getDefault().logError("Could not write value to " + e.getQualifiedString(), (Exception)((Object)ex));
            }
        }
    }

    public static void handleSubappPinWrite(MonitoringElement element, SystemMonitoringData data, Collection<MonitoringElement> elements) {
        MonitoringElement anchor = (MonitoringElement)((SubappMonitoringElement)element).getAnchor();
        if (element.getPort().getInterfaceElement().isIsInput()) {
            Map.Entry<String, List<MonitoringElement>> subappElements = data.getSubappElements(element);
            Assert.isNotNull(subappElements);
            elements.addAll((Collection<MonitoringElement>)subappElements.getValue());
        } else {
            elements.add(anchor);
        }
    }

    public void forceValue(MonitoringElement element, String value) {
        AutomationSystem automationSystem = element.getPort().getSystem();
        if (automationSystem == null) {
            MonitoringManager.showSystemNotFoundErrorMsg(element);
            return;
        }
        Device device = element.getPort().getDevice();
        if (device == null) {
            MonitoringManager.showDeviceNotFounderroMsg(element);
            return;
        }
        ArrayList<MonitoringElement> elements = new ArrayList<MonitoringElement>();
        SystemMonitoringData data = this.getSystemMonitoringData(automationSystem);
        if (element instanceof SubappMonitoringElement) {
            MonitoringManager.handleSubappPinWrite(element, data, elements);
        } else {
            elements.add(element);
        }
        for (MonitoringElement e : elements) {
            e.forceValue(value);
            IDeviceManagementInteractor devMgmInteractor = this.getSystemMonitoringData(automationSystem).getDevMgmInteractor(device);
            if (devMgmInteractor == null) continue;
            try {
                if (e.isForce()) {
                    devMgmInteractor.forceValue((MonitoringBaseElement)e, value);
                    continue;
                }
                devMgmInteractor.clearForce((MonitoringBaseElement)e);
            }
            catch (DeploymentException ex) {
                Activator.getDefault().logError("Could not force value of " + e.getQualifiedString() + "to " + value, (Exception)((Object)ex));
            }
        }
    }

    public SystemMonitoringData getSystemMonitoringData(AutomationSystem system) {
        return this.systemMonitoringData.computeIfAbsent(system, SystemMonitoringData::new);
    }

    private static void showDeviceNotFounderroMsg(MonitoringElement element) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Device could not be found for FB port: " + element.getPort() + "."));
    }

    private static void showSystemNotFoundErrorMsg(MonitoringElement element) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("System could not be found for FB port: " + element.getPort() + "."));
    }
}

