/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.systemmanagement.Activator;

class DeviceMonitoringHandler
implements Runnable {
    private final Device device;
    private final IDeviceManagementInteractor devInteractor;
    private final SystemMonitoringData systemMonData;
    private final Thread thread;
    private boolean running = true;

    private synchronized void setRunning(boolean val) {
        this.running = val;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public DeviceMonitoringHandler(Device device, SystemMonitoringData systemMonData) {
        this.device = device;
        this.devInteractor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device);
        this.systemMonData = systemMonData;
        this.thread = new Thread(this);
    }

    public Thread getThread() {
        return this.thread;
    }

    public IDeviceManagementInteractor getDevMgmInteractor() {
        return this.devInteractor;
    }

    public synchronized void enable() {
        this.setRunning(true);
        this.thread.start();
    }

    public synchronized void disable() {
        this.setRunning(this.running);
    }

    @Override
    public void run() {
        if (this.devInteractor != null) {
            int pollingIntervall = PreferenceConstants.getPollingInterval();
            while (this.isRunning()) {
                try {
                    Thread.sleep(pollingIntervall);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.getDefault().logError(e.getMessage(), (Exception)e);
                }
                if (this.devInteractor.isConnected()) {
                    try {
                        Response resp = this.devInteractor.readWatches();
                        if (resp == null) continue;
                        this.updateWatches(resp);
                    }
                    catch (DeploymentException deploymentException) {
                        this.handleDeviceIssue();
                    }
                    continue;
                }
                this.setRunning(false);
            }
        }
    }

    private void updateWatches(Response resp) {
        if (resp.getWatches() != null) {
            for (Resource res : resp.getWatches().getResources()) {
                String resName = String.valueOf(this.device.getName()) + "." + res.getName() + ".";
                this.updateFbs(res, resName);
            }
        }
    }

    public void updateFbs(Resource res, String resName) {
        HashMap<String, SubappGroup> collectedGroups = new HashMap<String, SubappGroup>();
        for (FB fb : res.getFbs()) {
            String fbName = String.valueOf(resName) + fb.getName() + ".";
            for (Port port : fb.getPorts()) {
                String portString = String.valueOf(fbName) + port.getName();
                MonitoringBaseElement element = this.systemMonData.getMonitoringElementByPortString(portString);
                List<MonitoringElement> subappPins = this.systemMonData.getSubappElements().get(portString);
                Map.Entry<String, List<MonitoringElement>> subappEntry = this.systemMonData.getSubappElements(element);
                if (element != null && subappPins == null && subappEntry != null) {
                    subappPins = subappEntry.getValue();
                    portString = subappEntry.getKey();
                }
                if (subappPins != null) {
                    SubappGroup subappGroup = null;
                    if (collectedGroups.containsKey(portString)) {
                        subappGroup = collectedGroups.get(portString);
                    } else {
                        subappGroup = new SubappGroup(subappPins);
                        collectedGroups.put(portString, subappGroup);
                    }
                    if (element != null) {
                        subappGroup.assignPort((MonitoringElement)element, port);
                    }
                    subappGroup.assignSubappPorts(port, portString);
                    continue;
                }
                if (!(element instanceof MonitoringElement)) continue;
                DeviceMonitoringHandler.updateMonitoringElement((MonitoringElement)element, port);
            }
        }
        DeviceMonitoringHandler.updateSubappPorts(collectedGroups);
    }

    private static void updateSubappPorts(Map<String, SubappGroup> collectedGroups) {
        for (SubappGroup subappGroup : collectedGroups.values()) {
            DeviceMonitoringHandler.updateSubAppGroup(subappGroup);
        }
    }

    private static void updateSubAppGroup(SubappGroup subappGroup) {
        boolean inconsistent = false;
        String currentVal = "";
        for (MonitoringElement monitoringElement : subappGroup.collectedSubappPins) {
            Port port = subappGroup.getPort(monitoringElement);
            DeviceMonitoringHandler.updateMonitoringElement(monitoringElement, port);
            inconsistent = DeviceMonitoringHandler.isInconsistent(currentVal, monitoringElement);
            currentVal = monitoringElement.getCurrentValue();
        }
        if (inconsistent) {
            DeviceMonitoringHandler.setSubappPinsToInconsistentState(subappGroup);
        }
    }

    public static boolean isInconsistent(String currentVal, MonitoringElement monitoringElement) {
        return !currentVal.isEmpty() && !(monitoringElement instanceof SubappMonitoringElement) && !currentVal.equals(monitoringElement.getCurrentValue());
    }

    private static void setSubappPinsToInconsistentState(SubappGroup subappGroup) {
        subappGroup.collectedSubappPins.stream().filter(SubappMonitoringElement.class::isInstance).forEach(e -> e.setCurrentValue("?"));
    }

    private static void updateMonitoringElement(MonitoringElement monitoringElement, Port p) {
        for (Data d : p.getDataValues()) {
            long timeAsLong = 0L;
            try {
                timeAsLong = Long.parseLong(d.getTime());
            }
            catch (NumberFormatException numberFormatException) {
                timeAsLong = 0L;
            }
            monitoringElement.setSec(timeAsLong / 1000L);
            monitoringElement.setUsec(timeAsLong % 1000L);
            monitoringElement.setCurrentValue(d.getValue());
            if (d.getForced() == null) continue;
            monitoringElement.setForce(d.getForced().equals("true"));
        }
    }

    private void handleDeviceIssue() {
        try {
            this.devInteractor.disconnect();
        }
        catch (DeploymentException deploymentException) {}
        this.systemMonData.getMonitoredElements().stream().filter(el -> el.getPort().getDevice().equals(this.device) && el instanceof MonitoringElement).forEach(el -> ((MonitoringElement)el).setCurrentValue(""));
    }

    public static class SubappGroup {
        List<MonitoringElement> collectedSubappPins;
        HashMap<MonitoringElement, Port> pins = new HashMap();

        public SubappGroup(List<MonitoringElement> collectedSubappPins) {
            this.collectedSubappPins = collectedSubappPins;
        }

        public Port getPort(MonitoringElement e) {
            return this.pins.get(e);
        }

        public void assignPort(MonitoringElement e, Port p) {
            for (MonitoringElement monitoringElement : this.collectedSubappPins) {
                if (!(monitoringElement instanceof SubappMonitoringElement) || !((SubappMonitoringElement)monitoringElement).getAnchor().equals(e)) continue;
                this.pins.put(monitoringElement, p);
            }
            this.pins.put(e, p);
        }

        public void assignSubappPorts(Port p, String portString) {
            for (MonitoringElement monitoringElement : this.collectedSubappPins) {
                MonitoringBaseElement anchor;
                if (!(monitoringElement instanceof SubappMonitoringElement) || !(anchor = ((SubappMonitoringElement)monitoringElement).getAnchor()).getPort().getPortString().equals(portString)) continue;
                this.pins.computeIfAbsent(monitoringElement, e -> p);
            }
        }
    }
}

