/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementFigure;
import org.eclipse.fordiac.ide.model.commands.change.AttributeChangeCommand;
import org.eclipse.fordiac.ide.model.commands.create.AttributeCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class LayoutCommand
extends Command {
    private final Map<FBNetworkElement, Position> positions;
    private final Map<Connection, PointList> connPoints;
    private final Map<FBNetworkElement, FBNetworkElementFigure> fbFigures;
    private final Map<IInterfaceElement, Integer> pins;
    private final Map<FBNetworkElement, Position> oldPositions = new HashMap<FBNetworkElement, Position>();
    private final Map<Connection, ConnectionRoutingData> oldRoutingData = new HashMap<Connection, ConnectionRoutingData>();
    private final CompoundCommand pinPositionAttrCommand = new CompoundCommand();

    public LayoutCommand(Map<FBNetworkElement, Position> positions, Map<Connection, PointList> connPoints, Map<FBNetworkElement, FBNetworkElementFigure> fbFigures, Map<IInterfaceElement, Integer> pins) {
        this.positions = positions;
        this.connPoints = connPoints;
        this.fbFigures = fbFigures;
        this.pins = pins;
    }

    public void execute() {
        this.saveDataForUndo();
        this.updateModelElements();
        this.updatePositionAttributes();
        this.updateFigures();
        if (this.pinPositionAttrCommand.canExecute()) {
            this.pinPositionAttrCommand.execute();
        }
    }

    public void redo() {
        this.updateModelElements();
        this.updateFigures();
        if (this.pinPositionAttrCommand.canExecute()) {
            this.pinPositionAttrCommand.redo();
        }
    }

    public void undo() {
        this.oldPositions.forEach(PositionableElement::setPosition);
        this.oldRoutingData.forEach(Connection::setRoutingData);
        this.fbFigures.forEach((elem, fig) -> {
            Position pos = this.oldPositions.get(elem);
            fig.setLocation(new Point(pos.getX(), pos.getY()));
        });
        if (this.pinPositionAttrCommand.canExecute()) {
            this.pinPositionAttrCommand.undo();
        }
    }

    private void saveDataForUndo() {
        this.positions.keySet().forEach(elem -> {
            Position position = this.oldPositions.put((FBNetworkElement)elem, (Position)EcoreUtil.copy((EObject)elem.getPosition()));
        });
        this.connPoints.keySet().forEach(conn -> {
            ConnectionRoutingData connectionRoutingData = this.oldRoutingData.put((Connection)conn, (ConnectionRoutingData)EcoreUtil.copy((EObject)conn.getRoutingData()));
        });
    }

    private void updateModelElements() {
        this.positions.forEach(PositionableElement::setPosition);
        this.connPoints.forEach(LayoutCommand::updateModel);
    }

    private void updatePositionAttributes() {
        this.pins.forEach(this::updatePositionAttribute);
    }

    private void updatePositionAttribute(IInterfaceElement ie, Integer y) {
        String attrValue = y.toString();
        Attribute attr = ie.getAttribute("YPOSITION");
        Object cmd = attr == null ? new AttributeCreateCommand((ConfigurableObject)ie, "YPOSITION", "", attrValue) : new AttributeChangeCommand(attr, attrValue);
        this.pinPositionAttrCommand.add((Command)cmd);
    }

    private void updateFigures() {
        this.fbFigures.forEach((elem, fig) -> {
            Position pos = this.positions.get(elem);
            fig.setLocation(new Point(pos.getX(), pos.getY()));
        });
    }

    private static void updateModel(Connection connModel, PointList pointList) {
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        if (pointList.size() > 2) {
            routingData.setDx1(pointList.getPoint(1).x() - pointList.getFirstPoint().x());
            if (pointList.size() > 4) {
                routingData.setDy(pointList.getPoint(2).y() - pointList.getFirstPoint().y());
                routingData.setDx2(pointList.getLastPoint().x() - pointList.getPoint(pointList.size() - 2).x());
            }
        }
        connModel.setRoutingData(routingData);
    }
}

