/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.gef.widgets.TypeInfoWidget;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.SystemElementItemProviderAdapterFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.properties.UndoablePropertySheetPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class SystemEditor
extends EditorPart
implements CommandStackEventListener,
ITabbedPropertySheetPageContributor,
ISelectionListener {
    private static final ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemEditor.createFactoryList());
    private AutomationSystem system;
    private Form form;
    private TypeInfoWidget typeInfo;
    private TreeViewer appTreeViewer;
    private TreeViewer sysConfTreeViewer;
    private ActionRegistry actionRegistry;
    private final List<String> selectionActions = new ArrayList<String>();
    private final List<String> stackActions = new ArrayList<String>();
    private final List<String> propertyActions = new ArrayList<String>();
    private final Adapter appListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (SystemEditor.this.appTreeViewer != null && !SystemEditor.this.appTreeViewer.getControl().isDisposed()) {
                SystemEditor.this.appTreeViewer.refresh();
            }
        }
    };
    private final Adapter sysConfListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (SystemEditor.this.sysConfTreeViewer != null && !SystemEditor.this.sysConfTreeViewer.getControl().isDisposed()) {
                SystemEditor.this.sysConfTreeViewer.refresh();
            }
        }
    };

    public void stackChanged(CommandStackEvent event) {
        this.updateActions(this.stackActions);
        this.firePropertyChange(257);
    }

    public String getContributorId() {
        return "org.eclipse.fordiac.ide.datatypeeditor.editors.DataTypeEditor";
    }

    public void dispose() {
        if (this.system != null) {
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
            this.system.eAdapters().remove((Object)this.appListener);
            this.system.getSystemConfiguration().eAdapters().remove((Object)this.sysConfListener);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.system != null) {
            SystemManager.saveSystem((AutomationSystem)this.system);
            this.getCommandStack().markSaveLocation();
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.loadSystem();
        if (this.system != null) {
            this.initializeActionRegistry();
            this.setActionHandlers(site);
        }
    }

    private void loadSystem() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            this.system = SystemManager.INSTANCE.getSystem(((FileEditorInput)this.getEditorInput()).getFile());
            if (this.system != null) {
                this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
                this.setPartName(this.system.getName());
                this.system.eAdapters().add((Object)this.appListener);
                this.system.getSystemConfiguration().eAdapters().add((Object)this.sysConfListener);
            }
        }
    }

    private void setActionHandlers(IEditorSite site) {
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    public boolean isDirty() {
        return this.system != null && this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void executeCommand(Command cmd) {
        CommandStack commandStack = this.getCommandStack();
        if (commandStack != null && cmd.canExecute()) {
            commandStack.execute(cmd);
        }
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        SashForm sash = new SashForm(this.form.getBody(), 512);
        toolkit.adapt((Composite)sash);
        sash.setLayoutData((Object)new GridData(1808));
        this.createInfoSection(toolkit, sash);
        Composite bottomComp = toolkit.createComposite((Composite)sash);
        bottomComp.setLayout((Layout)new GridLayout(2, true));
        bottomComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createApplicationsSection(toolkit, bottomComp);
        this.createSysconfSection(toolkit, bottomComp);
        if (this.system != null) {
            this.typeInfo.initialize((LibraryElement)this.system, this::executeCommand);
            this.typeInfo.refresh();
            this.appTreeViewer.setInput((Object)this.system.getApplication());
            this.sysConfTreeViewer.setInput((Object)this.system.getSystemConfiguration());
        }
    }

    private void createInfoSection(FormToolkit toolkit, SashForm sash) {
        Section infoSection = SystemEditor.createExpandableSection(toolkit, (Composite)sash, "System Information:");
        infoSection.setLayout((Layout)new GridLayout(1, true));
        this.typeInfo = new TypeInfoWidget(toolkit);
        Composite typeInfoRoot = this.typeInfo.createControls((Composite)infoSection);
        infoSection.setClient((Control)typeInfoRoot);
    }

    private static Section createExpandableSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 322);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setText(text);
        return section;
    }

    private void createApplicationsSection(FormToolkit toolkit, Composite bottomComp) {
        Section appSection = SystemEditor.createExpandableSection(toolkit, bottomComp, "Applications:");
        Composite appSecComposite = toolkit.createComposite((Composite)appSection);
        appSecComposite.setLayout((Layout)new GridLayout(2, false));
        appSection.setClient((Control)appSecComposite);
        Tree tree = toolkit.createTree(appSecComposite, 2820);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.appTreeViewer = new TreeViewer(tree);
        this.appTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)systemAdapterFactory){

            public boolean hasChildren(Object element) {
                return element instanceof EList || super.hasChildren(element);
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EList) {
                    return ((EList)parentElement).toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.appTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)systemAdapterFactory));
    }

    private void createSysconfSection(FormToolkit toolkit, Composite bottomComp) {
        Section sysConfSection = SystemEditor.createExpandableSection(toolkit, bottomComp, "System Configuration:");
        sysConfSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite sysConfSecComposite = toolkit.createComposite((Composite)sysConfSection);
        sysConfSecComposite.setLayout((Layout)new GridLayout(2, false));
        sysConfSection.setClient((Control)sysConfSecComposite);
        Tree tree = toolkit.createTree(sysConfSecComposite, 2820);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sysConfTreeViewer = new TreeViewer(tree);
        this.sysConfTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)systemAdapterFactory));
        this.sysConfTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)systemAdapterFactory));
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public CommandStack getCommandStack() {
        return this.system != null ? this.system.getCommandStack() : null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
            this.firePropertyChange(257);
        }
    }

    private void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new UndoablePropertySheetPage(this.getCommandStack(), this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()), this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId())));
        }
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == ActionRegistry.class) {
            return adapter.cast(this.getActionRegistry());
        }
        return (T)super.getAdapter(adapter);
    }

    private List<String> getStackActions() {
        return this.stackActions;
    }

    private void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    private void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        actionIds.forEach(id -> {
            IAction action = registry.getAction(id);
            if (action instanceof UpdateAction) {
                ((UpdateAction)action).update();
            }
        });
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>(2);
        factories.add((AdapterFactory)new SystemElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }
}

