/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.GraphicalViewerNavigationLocationData;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class BreadcrumbNavigationLocation
extends NavigationLocation {
    private final AbstractBreadCrumbEditor breadCrumbEditor;
    private final Object model;
    private GraphicalViewerNavigationLocationData viewerData = null;
    private final AdapterFactoryContentProvider contentProvider;
    private final AdapterFactoryLabelProvider labelProvider;

    protected BreadcrumbNavigationLocation(AbstractBreadCrumbEditor editorPart, Object model) {
        super((IEditorPart)editorPart);
        this.breadCrumbEditor = editorPart;
        this.model = model;
        this.contentProvider = editorPart.getBreadcrumb().getContentProvider();
        this.labelProvider = editorPart.getBreadcrumb().getLabelProvider();
        GraphicalViewer viewer = editorPart.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.viewerData = new GraphicalViewerNavigationLocationData(viewer);
        }
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        BreadcrumbNavigationLocation.generateItemPath(sb, this.model, this.contentProvider, this.labelProvider);
        return sb.substring(1);
    }

    public static void generateItemPath(StringBuilder sb, Object model, AdapterFactoryContentProvider adapterFactoryContentProvider, AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        if (model == null) {
            return;
        }
        BreadcrumbNavigationLocation.generateItemPath(sb, adapterFactoryContentProvider.getParent(model), adapterFactoryContentProvider, adapterFactoryLabelProvider);
        sb.append(".");
        sb.append(adapterFactoryLabelProvider.getText(model));
    }

    private Object getModel() {
        return this.model;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        if (this.breadCrumbEditor.getBreadcrumb().getActiveItem().getModel().equals(this.model)) {
            return;
        }
        this.breadCrumbEditor.getBreadcrumb().setInput(this.model);
        GraphicalViewer viewer = this.breadCrumbEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null && this.viewerData != null) {
            this.viewerData.restoreGraphicalViewerData((EditPartViewer)viewer);
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        BreadcrumbNavigationLocation currentBreadCrumbLocation;
        if (currentLocation instanceof BreadcrumbNavigationLocation && this.model == (currentBreadCrumbLocation = (BreadcrumbNavigationLocation)currentLocation).getModel()) {
            if (this.viewerData != null) {
                return this.viewerData.equals(currentBreadCrumbLocation.viewerData);
            }
            return true;
        }
        return false;
    }

    public void update() {
    }
}

