/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.validation;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyCharsType;
import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnySignedType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;

public final class ValueValidator {
    private static final String ST_UNDERSCORE_DIGIT_SEPARATOR = "_";
    private static final String VALIDATOR_ST_ESCAPE_DOUBLE_QUOTES = "$\"";
    private static final String BASE_SPECIFIER_HEXADECIMAL = "16";
    private static final String BASE_SPECIFIER_OCTAL = "8";
    private static final String BASE_SPECIFIER_BINARY = "2";
    private static final int MAX_SECONDS_OF_MINUTE = 60;
    private static final int MAX_MINUTES_OF_HOUR = 60;
    private static final int MAX_HOURS_OF_DAY = 24;
    private static final String DATE_SEPARATOR = "-";
    private static final String BOOL_FALSE = "FALSE";
    private static final String BOOL_TRUE = "TRUE";
    private static final String BOOL_ZERO = "0";
    private static final String BOOL_ONE = "1";
    private static final String ST_ESCAPE_SYMBOL = "$";
    private static final String ST_ESCAPE_WITH_SINGLE_QUOTE = "$'";
    private static final String EMPTY_STRING = "";
    private static final String REGEX_LITERAL_SPLITTER = "([a-zA-Z]*#)?([0-9]*#)?(.*)";
    private static final String REGEX_SIGNED = "[+-]?[0-9](?:_?[0-9])*+";
    private static final String REGEX_UNSIGNED = "[0-9](?:_?[0-9])*+";
    private static final String REGEX_HEX = "(?:_?[0-9a-fA-F])*+";
    private static final String REGEX_OCTAL = "(?:_?[0-7])*+";
    private static final String REGEX_BINARY = "(?:_?[0-1])*+";
    private static final String REGEX_REAL = "[+-]?[0-9](?:_?[0-9])*+.[0-9](?:_?[0-9])*+(?:[Ee][+-]?[0-9](?:_?[0-9])*+)?";
    private static final String REGEX_FIX_POINT = "[0-9](?:_?[0-9])*+(?:\\.[0-9](?:_?[0-9])*+)?";
    private static final String REGEX_TIME_OF_DAY = "[0-9](?:_?[0-9])*+:[0-9](?:_?[0-9])*+:[0-9](?:_?[0-9])*+(?:\\.[0-9](?:_?[0-9])*+)?";
    private static final String REGEX_DATE = "[0-9](?:_?[0-9])*+-[0-9](?:_?[0-9])*+-[0-9](?:_?[0-9])*+";
    private static final String H_REGEX_HEX_DIGIT = "[A-Fa-f0-9]";
    private static final String H_REGEX_SPECIAL_CHAR = "\\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T";
    private static final String H_REGEX_COMMON_CHAR = "[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T";
    private static final String H_REGEX_CHAR = "[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$' | \"|\\$[A-Fa-f0-9]{2}";
    private static final String REGEX_CHAR = "^' (?:[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$' | \"|\\$[A-Fa-f0-9]{2}) \\' $".replace(" ", "");
    private static final String REGEX_STRING = "^' (?:[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$' | \"|\\$[A-Fa-f0-9]{2})* \\' $".replace(" ", "");
    private static final String H_REGEX_WCHAR = "[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$\" | '|\\$[A-Fa-f0-9]{4}";
    private static final String REGEX_WCHAR = "^\\\" (?:[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$\" | '|\\$[A-Fa-f0-9]{4}) \\\" $".replace(" ", "");
    private static final String REGEX_WSTRING = "^\\\" (?:[^ \" ' \\$ ] | \\$\\$ | \\$L | \\$N | \\$P | \\$R | \\$T|\\$\" | '|\\$[A-Fa-f0-9]{4})* \\\" $".replace(" ", "");
    private static final String[] timeNames = new String[]{"d", "h", "m", "s", "ms", "us", "ns"};
    private static final int[] timesMaxs = new int[]{365, 24, 60, 60, 1000, 1000, 1000};
    private static final String TIME_SHORT_FORM = "T";
    private static final String LONG_TIME_SHORT_FORM = "LT";
    private static final String DATE_AND_TIME_SHORT_FORM = "DT";
    private static final Map<String, String> SHORT_FORM_TRANSLATIONS = Map.ofEntries(Map.entry("T", "TIME"), Map.entry("LT", "LTIME"), Map.entry("TOD", "TIME_OF_DAY"), Map.entry("LTOD", "LTIME_OF_DAY"), Map.entry("DT", "DATE_AND_TIME"), Map.entry("LDT", "LDATE_AND_TIME"));

    private static boolean isBoolLiteralValid(String literal) {
        return literal.equals(BOOL_ZERO) || literal.equals(BOOL_ONE) || literal.equalsIgnoreCase(BOOL_TRUE) || literal.equalsIgnoreCase(BOOL_FALSE);
    }

    private static boolean isSignedLiteralValid(String literal) {
        return literal.matches(REGEX_SIGNED);
    }

    private static boolean isUnsignedLiteralValid(String literal) {
        return literal.matches(REGEX_UNSIGNED);
    }

    private static boolean isHexBaseLiteralValid(String literal) {
        return literal.matches(REGEX_HEX);
    }

    private static boolean isOctalBaseLiteralValid(String literal) {
        return literal.matches(REGEX_OCTAL);
    }

    private static boolean isBinaryBaseLiteralValid(String literal) {
        return literal.matches(REGEX_BINARY);
    }

    private static boolean isRealLiteralValid(String literal) {
        return literal.matches(REGEX_REAL);
    }

    private static boolean isFixPointStringValid(String literalValue) {
        return literalValue.matches(REGEX_FIX_POINT);
    }

    private static String isTODStringValid(String literalValue) {
        if (!literalValue.matches(REGEX_TIME_OF_DAY)) {
            return Messages.VALIDATOR_INVALID_FORMAT_TOD_LITERAL;
        }
        String[] parts = literalValue.replace(ST_UNDERSCORE_DIGIT_SEPARATOR, EMPTY_STRING).split(":");
        String errorString = EMPTY_STRING;
        if (Integer.parseInt(parts[0]) >= 24) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_HOURS_VALUE_CANT_BE_24;
        }
        if (Integer.parseInt(parts[1]) >= 60) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_MINUTE_VALUE_CANT_BE_LARGER_THAN_60;
        }
        if (Float.parseFloat(parts[2]) >= 60.0f) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_SECONDS_VALUE_CANT_BE_LARGER_THAN_60;
        }
        return errorString;
    }

    public static String validateValue(DataType type, String value) {
        Pattern pattern = Pattern.compile(REGEX_LITERAL_SPLITTER);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.find()) {
            return Messages.VALIDATOR_UNKOWN_LITERAL_ERROR_PLEASE_CHECK_SANENESS_OF_LITERAL;
        }
        String typeSpecifier = matcher.group(1);
        typeSpecifier = typeSpecifier != null ? typeSpecifier.replace("#", EMPTY_STRING) : EMPTY_STRING;
        String baseSpecifier = matcher.group(2);
        baseSpecifier = baseSpecifier != null ? baseSpecifier.replace("#", EMPTY_STRING) : EMPTY_STRING;
        DataType literalType = null;
        if (!typeSpecifier.isBlank()) {
            literalType = IecTypes.ElementaryTypes.getTypeByName(typeSpecifier);
            if (literalType == null) {
                literalType = IecTypes.ElementaryTypes.getTypeByName(SHORT_FORM_TRANSLATIONS.get(typeSpecifier));
            }
        } else {
            literalType = type;
        }
        if (literalType == null) {
            return Messages.VALIDATOR_UNKNOWN_LITERAL_TYPE;
        }
        if (!literalType.isCompatibleWith(type)) {
            return MessageFormat.format(Messages.VALIDATOR_LITERAL_TYPE_INCOMPATIBLE_WITH_INPUT_TYPE, literalType.getName(), type.getName());
        }
        String literalValue = matcher.group(3);
        if (literalType instanceof AnyBitType) {
            return ValueValidator.checkAnyBitLiteral(literalType, baseSpecifier, literalValue);
        }
        if (literalType instanceof AnyIntType) {
            return ValueValidator.checkAnyIntLiteral(literalType, baseSpecifier, literalValue);
        }
        if (literalType instanceof AnyRealType) {
            return ValueValidator.checkAnyRealLiteral(literalType, typeSpecifier, baseSpecifier, literalValue);
        }
        if (literalType instanceof AnyDurationType) {
            return ValueValidator.checkDurationLiteral(literalType, baseSpecifier, literalValue);
        }
        if (literalType instanceof AnyDateType) {
            return ValueValidator.checkAnyDateLiteral(literalType, literalValue);
        }
        if (literalType instanceof AnyCharsType) {
            return ValueValidator.checkAnyCharsLiteral(literalType, baseSpecifier, literalValue);
        }
        return EMPTY_STRING;
    }

    private static String checkAnyCharsLiteral(DataType type, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!baseSpecifier.isBlank()) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_BASE_SPECIFIER_IS_INVALID_FOR, type.getName());
        }
        if (type instanceof CharType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkCharLiteral(type, literalValue);
        } else if (type instanceof WcharType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkWcharLiteral(type, literalValue);
        } else if (type instanceof StringType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkStringLiteral(type, literalValue);
        } else if (type instanceof WstringType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkWstringLiteral(type, literalValue);
        }
        return errorString;
    }

    private static String checkWstringLiteral(DataType type, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!literalValue.matches(REGEX_WSTRING)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_INVALID_WSTRING_WCHAR_LITERAL, type.getName(), type.getName());
            if (literalValue.contains(ST_ESCAPE_WITH_SINGLE_QUOTE)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_STRING_QUOTE_DOES_NOT_NEED_ESCAPE_SYMBOL;
            }
            if (literalValue.contains(ST_ESCAPE_SYMBOL)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_W_STRING_DOLLAR_IS_ESCAPE_SYMBOL;
            }
        }
        return errorString;
    }

    private static String checkWcharLiteral(DataType type, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!literalValue.matches(REGEX_WCHAR)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_INVALID_WSTRING_WCHAR_LITERAL, type.getName(), type.getName());
            if (literalValue.contains(ST_ESCAPE_WITH_SINGLE_QUOTE)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_STRING_QUOTE_DOES_NOT_NEED_ESCAPE_SYMBOL;
            }
            if (literalValue.contains(ST_ESCAPE_SYMBOL)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_W_STRING_DOLLAR_IS_ESCAPE_SYMBOL;
            }
            if (literalValue.length() == 2) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_EMPTY_CHARACTERS_ARE_NOT_ALLOWED;
            }
        }
        return errorString;
    }

    private static String checkCharLiteral(DataType type, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!literalValue.matches(REGEX_CHAR)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_INVALID_STRING_CHAR_LITERAL, type.getName(), type.getName());
            if (literalValue.contains(VALIDATOR_ST_ESCAPE_DOUBLE_QUOTES)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_WSTRING_QUOTES_HAVE_NOT_TO_BE_ESCAPED;
            }
            if (literalValue.contains(ST_ESCAPE_SYMBOL)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_W_STRING_DOLLAR_IS_ESCAPE_SYMBOL;
            }
            if (literalValue.length() == 2) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_EMPTY_CHARACTERS_ARE_NOT_ALLOWED;
            }
        }
        return errorString;
    }

    private static String checkStringLiteral(DataType type, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!literalValue.matches(REGEX_STRING)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_INVALID_STRING_CHAR_LITERAL, type.getName(), type.getName());
            if (literalValue.contains(VALIDATOR_ST_ESCAPE_DOUBLE_QUOTES)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_WSTRING_QUOTES_HAVE_NOT_TO_BE_ESCAPED;
            }
            if (literalValue.contains(ST_ESCAPE_SYMBOL)) {
                errorString = String.valueOf(errorString) + Messages.VALIDATOR_W_STRING_DOLLAR_IS_ESCAPE_SYMBOL;
            }
        }
        return errorString;
    }

    private static String checkAnyDateLiteral(DataType type, String literalValue) {
        String errorString = EMPTY_STRING;
        if (type instanceof DateType || type instanceof LdateType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkDateLiteral(literalValue);
        } else if (type instanceof DateAndTimeType || type instanceof LdtType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkDateAndTimeLiteral(literalValue);
        } else if (type instanceof TimeOfDayType || type instanceof LtodType) {
            errorString = String.valueOf(errorString) + ValueValidator.isTODStringValid(literalValue);
        }
        return errorString;
    }

    private static boolean isDateStringValid(String literalValue) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        if (!literalValue.matches(REGEX_DATE)) {
            return false;
        }
        try {
            return dateFormat.parse(literalValue.replace(ST_UNDERSCORE_DIGIT_SEPARATOR, EMPTY_STRING)) != null;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private static String checkDateLiteral(String literalValue) {
        String errorString = EMPTY_STRING;
        if (!ValueValidator.isDateStringValid(literalValue)) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_INVALID_DATE_FORMAT;
        }
        return errorString;
    }

    private static boolean isDaTLiteralValid(String literalValue) {
        int index = literalValue.lastIndexOf(DATE_SEPARATOR);
        if (index == -1) {
            return false;
        }
        String date = literalValue.substring(0, index);
        String time = literalValue.substring(index + 1);
        return ValueValidator.isDateStringValid(date) && ValueValidator.isTODStringValid(time).isBlank();
    }

    private static String checkDateAndTimeLiteral(String literalValue) {
        String errorString = EMPTY_STRING;
        if (!ValueValidator.isDaTLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_INVALID_DATE_AND_TIME_FORMAT;
        }
        return errorString;
    }

    private static String checkDurationLiteral(DataType type, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!baseSpecifier.isBlank()) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_BASE_SPECIFIER_INVALID_FOR_TYPE, type.getName());
        }
        if ((type instanceof TimeType || type instanceof LtimeType) && !(errorString = String.valueOf(errorString) + ValueValidator.isTimeIntervalLiteralValid(literalValue)).isBlank()) {
            errorString = String.valueOf(Messages.VALIDATOR_INVALID_TIME_LITERAL) + errorString;
        }
        return errorString;
    }

    private static String isTimeIntervalLiteralValid(String literalValue) {
        literalValue = literalValue.replaceFirst("^[+-]", EMPTY_STRING);
        return ValueValidator.isTimeIntervalStringValid(literalValue, 0, true);
    }

    private static String isTimeIntervalStringValid(String literalValue, int timeNamePos, boolean isMSV) {
        String lowerCaseLiteralValue;
        if (timeNamePos >= timeNames.length) {
            return Messages.VALIDATOR_TOO_MANY_TIME_DEFINITIONS_FOUND;
        }
        String regex = ".*?(?:_|[0-9])(?<unit>" + timeNames[timeNamePos] + ")(?:(_|[0-9]).*)?";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(lowerCaseLiteralValue = literalValue.toLowerCase());
        if (!matcher.matches()) {
            return ValueValidator.isTimeIntervalStringValid(lowerCaseLiteralValue, timeNamePos + 1, isMSV);
        }
        String biggestTime = lowerCaseLiteralValue.substring(0, matcher.start("unit"));
        if (matcher.end(1) + 1 > lowerCaseLiteralValue.length()) {
            if (!biggestTime.matches(REGEX_UNSIGNED) && !ValueValidator.isFixPointStringValid(biggestTime)) {
                return Messages.VALIDATOR_INVALID_TIME_LITERAL;
            }
            if (!isMSV && !(Float.parseFloat(biggestTime.replace(ST_UNDERSCORE_DIGIT_SEPARATOR, EMPTY_STRING)) < (float)timesMaxs[timeNamePos])) {
                return MessageFormat.format(Messages.VALIDATOR_ST_TIME_LITERAL_OVERFLOW_ERROR, biggestTime, timeNames[timeNamePos], timesMaxs[timeNamePos]);
            }
            return EMPTY_STRING;
        }
        if (!biggestTime.matches(REGEX_UNSIGNED)) {
            String errSTr = Messages.VALIDATOR_ST_TIME_LITERAL_ERROR_UNSIGNED_EXPECTED;
            return MessageFormat.format(errSTr, biggestTime, timeNames[timeNamePos]);
        }
        if (!isMSV && Integer.parseInt(biggestTime.replace(ST_UNDERSCORE_DIGIT_SEPARATOR, EMPTY_STRING)) > timesMaxs[timeNamePos]) {
            return MessageFormat.format(Messages.VALIDATOR_ST_TIME_LITERAL_OVERFLOW_ERROR, biggestTime, timeNames[timeNamePos], timesMaxs[timeNamePos]);
        }
        String subTime = lowerCaseLiteralValue.substring(matcher.end("unit"), lowerCaseLiteralValue.length());
        subTime = subTime.replaceFirst("^_", EMPTY_STRING);
        return ValueValidator.isTimeIntervalStringValid(subTime, timeNamePos + 1, false);
    }

    private static String checkAnyBitLiteral(DataType type, String baseSpecifier, String literalValue) {
        if (type instanceof BoolType) {
            return ValueValidator.checkBookLiteral(baseSpecifier, literalValue);
        }
        String errorString = EMPTY_STRING;
        if (baseSpecifier.isBlank() && !ValueValidator.isUnsignedLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_UNSIGNED_VALUE_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_BINARY) && !ValueValidator.isBinaryBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_BINARY_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_OCTAL) && !ValueValidator.isOctalBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_OCTAL_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_HEXADECIMAL) && !ValueValidator.isHexBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_HEXADECIMAL_NUMBER_CLAUSE, type.getName());
        }
        return errorString;
    }

    private static String checkAnyRealLiteral(DataType type, String typeSpecifier, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!baseSpecifier.isBlank()) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_BASE_SPECIFIER_IS_INVALID_FOR, type.getName());
        }
        if (typeSpecifier.isBlank()) {
            if (!(ValueValidator.isRealLiteralValid(literalValue) || ValueValidator.isSignedLiteralValid(literalValue) || ValueValidator.isBinaryBaseLiteralValid(literalValue) || ValueValidator.isOctalBaseLiteralValid(literalValue) || ValueValidator.isHexBaseLiteralValid(literalValue))) {
                errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_REAL_VALUE, type.getName());
            }
        } else if (!ValueValidator.isRealLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_REAL_VALUE, type.getName());
        }
        return errorString;
    }

    private static String checkAnyIntLiteral(DataType type, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!(baseSpecifier.isBlank() || baseSpecifier.equals(BASE_SPECIFIER_BINARY) || baseSpecifier.equals(BASE_SPECIFIER_OCTAL) || baseSpecifier.equals(BASE_SPECIFIER_HEXADECIMAL))) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_INVALID_BASE_SPECIFIER;
        }
        if (type instanceof AnySignedType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkAnySignedLiteral(type, baseSpecifier, literalValue);
        }
        if (type instanceof AnyUnsignedType) {
            errorString = String.valueOf(errorString) + ValueValidator.checkAnyUnsignedLiteral(type, baseSpecifier, literalValue);
        }
        return errorString;
    }

    private static String checkAnyUnsignedLiteral(DataType type, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (baseSpecifier.isBlank() && !ValueValidator.isUnsignedLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_UNSIGNED_VALUE_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_BINARY) && !ValueValidator.isBinaryBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_BINARY_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_OCTAL) && !ValueValidator.isOctalBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_OCTAL_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_HEXADECIMAL) && !ValueValidator.isHexBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_HEXADECIMAL_NUMBER_CLAUSE, type.getName());
        }
        return errorString;
    }

    private static String checkAnySignedLiteral(DataType type, String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (baseSpecifier.isBlank() && !ValueValidator.isSignedLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_SIGNED_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_BINARY) && !ValueValidator.isBinaryBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_BINARY_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_OCTAL) && !ValueValidator.isOctalBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_OCTAL_NUMBER_CLAUSE, type.getName());
        } else if (baseSpecifier.equals(BASE_SPECIFIER_HEXADECIMAL) && !ValueValidator.isHexBaseLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + MessageFormat.format(Messages.VALIDATOR_VALID_HEXADECIMAL_NUMBER_CLAUSE, type.getName());
        }
        return errorString;
    }

    private static String checkBookLiteral(String baseSpecifier, String literalValue) {
        String errorString = EMPTY_STRING;
        if (!baseSpecifier.isBlank()) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_NO_BASE_SPECIFIER_FOR_BOOL;
        }
        if (!ValueValidator.isBoolLiteralValid(literalValue)) {
            errorString = String.valueOf(errorString) + Messages.VALIDATOR_INVALID_BOOL_LITERAL;
        }
        return errorString;
    }

    private ValueValidator() {
        throw new UnsupportedOperationException("helper class ValueValidator should not be instantiated");
    }
}

