/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.datatype.helper;

import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;

public final class ElementaryDataTypeCompatibility {
    public static boolean isRealCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.REAL || ElementaryDataTypeCompatibility.isLRealCompatibleWith(other);
    }

    public static boolean isLRealCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LREAL || other == IecTypes.GenericTypes.ANY_REAL || ElementaryDataTypeCompatibility.isAnyNumCompatibleWith(other);
    }

    public static boolean isUsintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.USINT || ElementaryDataTypeCompatibility.isUintCompatibleWith(other) || ElementaryDataTypeCompatibility.isIntCompatibleWith(other);
    }

    public static boolean isUintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.UINT || ElementaryDataTypeCompatibility.isUdintCompatibleWith(other) || ElementaryDataTypeCompatibility.isRealCompatibleWith(other) || ElementaryDataTypeCompatibility.isDintCompatibleWith(other);
    }

    public static boolean isUdintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.UDINT || ElementaryDataTypeCompatibility.isUlintCompatibleWith(other) || ElementaryDataTypeCompatibility.isLRealCompatibleWith(other) || ElementaryDataTypeCompatibility.isLintCompatibleWith(other);
    }

    public static boolean isUlintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.ULINT || ElementaryDataTypeCompatibility.isAnyUnsignedCompatibleWith(other);
    }

    public static boolean isSintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.SINT || ElementaryDataTypeCompatibility.isIntCompatibleWith(other);
    }

    public static boolean isIntCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.INT || ElementaryDataTypeCompatibility.isDintCompatibleWith(other) || ElementaryDataTypeCompatibility.isRealCompatibleWith(other);
    }

    public static boolean isDintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.DINT || ElementaryDataTypeCompatibility.isLintCompatibleWith(other) || ElementaryDataTypeCompatibility.isLRealCompatibleWith(other);
    }

    public static boolean isLintCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LINT || ElementaryDataTypeCompatibility.isAnySignedCompatibleWith(other);
    }

    public static boolean isTimeCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.TIME || ElementaryDataTypeCompatibility.isLtimeCompatibleWith(other);
    }

    public static boolean isLtimeCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LTIME || other == IecTypes.GenericTypes.ANY_DURATION || ElementaryDataTypeCompatibility.isAnyMagnitudeCompatibleWith(other);
    }

    public static boolean isBoolCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.BOOL || ElementaryDataTypeCompatibility.isByteCompatibleWith(other);
    }

    public static boolean isByteCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.BYTE || ElementaryDataTypeCompatibility.isWordCompatibleWith(other);
    }

    public static boolean isWordCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.WORD || ElementaryDataTypeCompatibility.isDwordCompatibleWith(other);
    }

    public static boolean isDwordCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.DWORD || ElementaryDataTypeCompatibility.isLwordCompatibleWith(other);
    }

    public static boolean isLwordCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LWORD || other == IecTypes.GenericTypes.ANY_BIT || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isStringCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.STRING || other == IecTypes.GenericTypes.ANY_STRING || ElementaryDataTypeCompatibility.isAnyCharsCompatibleWith(other);
    }

    public static boolean isWstringCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.WSTRING || other == IecTypes.GenericTypes.ANY_STRING || ElementaryDataTypeCompatibility.isAnyCharsCompatibleWith(other);
    }

    public static boolean isCharCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.CHAR || ElementaryDataTypeCompatibility.isStringCompatibleWith(other);
    }

    public static boolean isWcharCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.WCHAR || ElementaryDataTypeCompatibility.isWstringCompatibleWith(other);
    }

    public static boolean isDateAndTimeCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.DATE_AND_TIME || ElementaryDataTypeCompatibility.isAnyDateCompatibleWith(other);
    }

    public static boolean isLdtCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LDT || ElementaryDataTypeCompatibility.isAnyDateCompatibleWith(other);
    }

    public static boolean isDateCompatibleWith(DataType other) {
        return ElementaryDataTypeCompatibility.isAnyDateCompatibleWith(other);
    }

    public static boolean isTimeOfDayCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.TIME_OF_DAY || ElementaryDataTypeCompatibility.isAnyDateCompatibleWith(other);
    }

    public static boolean isLtodCompatibleWith(DataType other) {
        return other == IecTypes.ElementaryTypes.LTOD || ElementaryDataTypeCompatibility.isAnyDateCompatibleWith(other);
    }

    public static boolean isAnyCharsCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_CHARS || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isAnyUnsignedCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_SIGNED || ElementaryDataTypeCompatibility.isAnyIntCompatibleWith(other);
    }

    public static boolean isAnySignedCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_SIGNED || ElementaryDataTypeCompatibility.isAnyIntCompatibleWith(other);
    }

    public static boolean isAnyIntCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_INT || ElementaryDataTypeCompatibility.isAnyNumCompatibleWith(other);
    }

    public static boolean isAnyNumCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_NUM || ElementaryDataTypeCompatibility.isAnyMagnitudeCompatibleWith(other);
    }

    public static boolean isAnyMagnitudeCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_MAGNITUDE || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isAnyElementaryCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_ELEMENTARY || ElementaryDataTypeCompatibility.isAnyCompatibleWith(other);
    }

    public static boolean isAnyCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY;
    }

    private static boolean isAnyDateCompatibleWith(DataType other) {
        return other == IecTypes.GenericTypes.ANY_DATE || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    private ElementaryDataTypeCompatibility() {
        throw new UnsupportedOperationException();
    }
}

