/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class ConnectionHelper {
    public static IInterfaceElement createRepairInterfaceElement(IInterfaceElement connection, String name) {
        IInterfaceElement repairIE = null;
        if (connection instanceof AdapterDeclaration) {
            repairIE = InterfaceListCopier.copyAdapter((AdapterDeclaration)connection);
        } else if (connection instanceof VarDeclaration) {
            repairIE = InterfaceListCopier.copyVar((VarDeclaration)connection, false);
        } else if (connection instanceof Event) {
            repairIE = InterfaceListCopier.copyEvent((Event)connection);
        }
        if (repairIE != null) {
            repairIE.setIsInput(!connection.isIsInput());
            repairIE.setName(name);
        }
        return repairIE;
    }

    public static ErrorMarkerInterface createErrorMarkerInterface(DataType type, String name, boolean isInput, InterfaceList ieList) {
        return (ErrorMarkerInterface)ieList.getErrorMarker().stream().filter(e -> e.getName().equals(name) && isInput == e.isIsInput()).findAny().orElseGet(() -> ConnectionHelper.createErrorMarker(type, name, isInput, ieList));
    }

    private static ErrorMarkerInterface createErrorMarker(DataType type, String name, boolean isInput, InterfaceList ieList) {
        ErrorMarkerInterface errorMarkerInterface = LibraryElementFactory.eINSTANCE.createErrorMarkerInterface();
        errorMarkerInterface.setName(name);
        errorMarkerInterface.setIsInput(isInput);
        errorMarkerInterface.setType(type);
        errorMarkerInterface.setTypeName(type.getName());
        ieList.getErrorMarker().add((Object)errorMarkerInterface);
        return errorMarkerInterface;
    }

    private ConnectionHelper() {
        throw new UnsupportedOperationException();
    }

    public static class ConnectionBuilder {
        private Set<ConnectionState> connectionState = EnumSet.of(ConnectionState.VALID);
        private String destination;
        private InterfaceList destInterfaceList;
        private IInterfaceElement destinationEndpoint;
        private String source;
        private InterfaceList srcInterfaceList;
        private IInterfaceElement sourceEndpoint;

        public ConnectionBuilder(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        public void validate() {
            if (this.sourceEndpoint != null && this.destinationEndpoint != null) {
                return;
            }
            if (this.sourceEndpoint != null) {
                this.connectionState.add(ConnectionState.SOURCE_ENDPOINT_EXISTS);
            } else {
                this.connectionState.add(ConnectionState.SOURCE_ENDPOINT_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (this.srcInterfaceList != null) {
                this.connectionState.add(ConnectionState.SOURCE_EXITS);
            } else {
                this.connectionState.add(ConnectionState.SOURCE_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (this.destinationEndpoint != null) {
                this.connectionState.add(ConnectionState.DEST_ENPOINT_EXITS);
            } else {
                this.connectionState.add(ConnectionState.DEST_ENDPOINT_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (this.destination != null && this.destInterfaceList != null) {
                this.connectionState.add(ConnectionState.DEST_EXISTS);
            } else {
                this.connectionState.add(ConnectionState.DEST_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
        }

        protected static InterfaceList getInterfaceFromQualString(String source, FBNetwork fbNetwork) {
            if (source == null) {
                return null;
            }
            String[] qualNames = source.split("\\.");
            if (qualNames.length == 0) {
                return null;
            }
            FBNetworkElement fbNetworkElement = fbNetwork.getElementNamed(qualNames[0]);
            if (fbNetworkElement == null) {
                return ConnectionBuilder.getElementFromType(fbNetwork);
            }
            return fbNetworkElement.getInterface();
        }

        private static InterfaceList getElementFromType(FBNetwork fbNetwork) {
            if (fbNetwork.eContainer() instanceof FBType) {
                FBType type = (FBType)fbNetwork.eContainer();
                return type.getInterfaceList();
            }
            return null;
        }

        public String getSourceFbName() {
            if (this.source == null) {
                return Messages.ConnectionHelper_ErrorMarker_Source_Missing;
            }
            String[] qualNames = this.source.split("\\.");
            if (qualNames.length == 0) {
                return Messages.ConnectionHelper_ErrorMarker_Source_Missing;
            }
            return qualNames[0];
        }

        public String getDestFbName() {
            if (this.destination == null) {
                return Messages.ConnectionHelper_ErrorMarker_Dest_Missing;
            }
            String[] qualNames = this.destination.split("\\.");
            if (qualNames.length == 0) {
                return Messages.ConnectionHelper_ErrorMarker_Dest_Missing;
            }
            return qualNames[0];
        }

        public Set<ConnectionState> getConnectionState() {
            return this.connectionState;
        }

        public String getDestination() {
            return this.destination;
        }

        public IInterfaceElement getDestinationEndpoint() {
            return this.destinationEndpoint;
        }

        public String getSource() {
            return this.source;
        }

        public IInterfaceElement getSourceEndpoint() {
            return this.sourceEndpoint;
        }

        public boolean isMissingConnectionDestination() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.DEST_MISSING, ConnectionState.SOURCE_ENDPOINT_EXISTS));
        }

        public boolean isValidConnection() {
            return this.connectionState.contains((Object)ConnectionState.VALID);
        }

        public boolean isMissingConnectionDestinationEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.DEST_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.SOURCE_ENDPOINT_EXISTS, ConnectionState.DEST_EXISTS));
        }

        public boolean isMissingConnectionSource() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_MISSING, ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.DEST_EXISTS, ConnectionState.DEST_ENPOINT_EXITS));
        }

        public boolean isMissingConnectionSourceEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.DEST_EXISTS, ConnectionState.DEST_ENPOINT_EXITS));
        }

        public boolean isMissingSourceAndDestEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.DEST_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.DEST_EXISTS));
        }

        public String getSourcePinName() {
            if (this.source == null) {
                return Messages.ConnectionHelper_pin_not_found;
            }
            if (this.sourceEndpoint != null) {
                return this.sourceEndpoint.getName();
            }
            String[] qualNames = this.source.split("\\.");
            if (qualNames.length < 2) {
                return null;
            }
            return qualNames[1];
        }

        public String getDestinationPinName() {
            if (this.destination == null) {
                return Messages.ConnectionHelper_pin_not_found;
            }
            if (this.destinationEndpoint != null) {
                return this.destinationEndpoint.getName();
            }
            String[] qualNames = this.destination.split("\\.");
            if (qualNames.length < 2) {
                return Messages.ConnectionHelper_pin_not_found;
            }
            return qualNames[1];
        }

        public InterfaceList getDestInterfaceList() {
            return this.destInterfaceList;
        }

        public void setDestInterfaceList(InterfaceList destInterfaceList) {
            this.destInterfaceList = destInterfaceList;
        }

        public InterfaceList getSrcInterfaceList() {
            return this.srcInterfaceList;
        }

        public void setSrcInterfaceList(InterfaceList srcInterfaceList) {
            this.srcInterfaceList = srcInterfaceList;
        }

        public void setConnectionState(Set<ConnectionState> connectionState) {
            this.connectionState = connectionState;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public void setDestinationEndpoint(IInterfaceElement destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSourceEndpoint(IInterfaceElement sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint;
        }
    }

    public static enum ConnectionState {
        VALID,
        SOURCE_MISSING,
        SOURCE_ENDPOINT_MISSING,
        DEST_MISSING,
        DEST_ENDPOINT_MISSING,
        SOURCE_EXITS,
        SOURCE_ENDPOINT_EXISTS,
        DEST_EXISTS,
        DEST_ENPOINT_EXITS,
        MISSING_TYPE;

    }
}

