/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.validation.ValueValidator;

public abstract class CommonElementImporter {
    private XMLStreamReader reader;
    private final IFile file;
    private final TypeLibrary typeLibrary;
    private LibraryElement element;
    protected final List<ErrorMarkerBuilder> errorMarkerAttributes;

    protected static VarDeclaration getVarNamed(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration retVal;
        boolean hasType = true;
        if (interfaceList.eContainer() instanceof FB) {
            boolean bl = hasType = ((FB)interfaceList.eContainer()).getPaletteEntry() != null;
        }
        if (hasType) {
            retVal = interfaceList.getVariable(varName);
            if (retVal != null && retVal.isIsInput() != input) {
                retVal = null;
            }
        } else {
            retVal = CommonElementImporter.createVarDecl(interfaceList, varName, input);
        }
        return retVal;
    }

    private static VarDeclaration createVarDecl(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration variable = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        variable.setName(varName);
        variable.setIsInput(input);
        if (input) {
            interfaceList.getInputVars().add((Object)variable);
        } else {
            interfaceList.getOutputVars().add((Object)variable);
        }
        return variable;
    }

    protected IFile getFile() {
        return this.file;
    }

    protected TypeLibrary getTypeLibrary() {
        return this.typeLibrary;
    }

    protected Palette getPalette() {
        return this.getTypeLibrary().getBlockTypeLib();
    }

    protected FBTypePaletteEntry getTypeEntry(String typeFbElement) {
        if (typeFbElement != null) {
            return this.getPalette().getFBTypeEntry(typeFbElement);
        }
        return null;
    }

    protected DataTypeLibrary getDataTypeLibrary() {
        return this.getTypeLibrary().getDataTypeLibrary();
    }

    public LibraryElement getElement() {
        return this.element;
    }

    protected void setElement(LibraryElement element) {
        this.element = element;
    }

    protected CommonElementImporter(IFile file) {
        Assert.isNotNull((Object)file);
        this.file = file;
        this.typeLibrary = TypeLibrary.getTypeLibrary(file.getProject());
        this.errorMarkerAttributes = new ArrayList<ErrorMarkerBuilder>();
    }

    protected CommonElementImporter(CommonElementImporter importer) {
        Assert.isNotNull((Object)importer);
        this.reader = importer.reader;
        this.file = importer.file;
        this.typeLibrary = importer.typeLibrary;
        this.errorMarkerAttributes = importer.errorMarkerAttributes;
    }

    public void loadElement() {
        this.element = this.createRootModelElement();
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ImporterStreams streams = this.createInputStreams(this.getInputStream());){
                    this.deleteMarkers();
                    this.proceedToStartElementNamed(this.getStartElementName());
                    this.readNameCommentAttributes(this.element);
                    this.processChildren(this.getStartElementName(), this.getBaseChildrenHandler());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.getDefault().logWarning("Type Loading issue", e);
                this.createErrorMarker(e.getMessage());
                this.buildErrorMarker(this.file);
            }
        }
        finally {
            this.buildErrorMarker(this.file);
        }
    }

    protected InputStream getInputStream() throws Exception {
        return this.file.getContents();
    }

    protected ErrorMarkerBuilder createErrorMarker(String message) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("message", message);
        ErrorMarkerBuilder e = FordiacMarkerHelper.createErrorMarkerBuilder(attrs, this.getLineNumber());
        this.errorMarkerAttributes.add(e);
        return e;
    }

    private void buildErrorMarker(final IFile file) {
        WorkspaceJob job = new WorkspaceJob("Add error marker to file: " + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                CommonElementImporter.this.errorMarkerAttributes.stream().forEach(a -> FordiacMarkerHelper.createMarkerInFile(a, file));
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getProject());
        job.schedule();
    }

    protected abstract LibraryElement createRootModelElement();

    protected abstract String getStartElementName();

    protected abstract IChildHandler getBaseChildrenHandler();

    protected void deleteMarkers() {
        if (this.file.exists()) {
            WorkspaceJob job = new WorkspaceJob("Remove error markers from file: " + this.file.getName()){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        CommonElementImporter.this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Could not delete error marker", (Exception)((Object)e));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)this.file.getProject());
            job.schedule();
        }
    }

    private ImporterStreams createInputStreams(InputStream fileInputStream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = factory.createXMLStreamReader(fileInputStream);
        return new ImporterStreams(fileInputStream, this.reader);
    }

    protected XMLStreamReader getReader() {
        return this.reader;
    }

    public int getLineNumber() {
        if (this.reader != null && this.reader.getLocation() != null) {
            return this.reader.getLocation().getLineNumber();
        }
        return -1;
    }

    protected void proceedToStartElementNamed(String elementName) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (1 != event || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        }
        throw new XMLStreamException("Could not find start element named: " + elementName);
    }

    protected void proceedToEndElementNamed(String elementName) throws XMLStreamException {
        do {
            if (2 != this.reader.getEventType() || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        } while (this.reader.hasNext() && this.reader.next() != 0);
        throw new XMLStreamException("Could not find end element named: " + elementName);
    }

    protected void processChildren(String elementName, IChildHandler childHandler) throws XMLStreamException, TypeImportException {
        while (this.getReader().hasNext()) {
            int event = this.getReader().next();
            if (1 == event) {
                if (childHandler.checkChild(this.getReader().getLocalName())) continue;
                throw new XMLStreamException("Unexpected xml child (" + this.getReader().getLocalName() + ") found in " + elementName);
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals(elementName)) break;
            throw new XMLStreamException("Unexpected xml end tag found in " + elementName + ": " + this.getReader().getLocalName());
        }
    }

    protected void parseIdentification(LibraryElement elem) throws XMLStreamException {
        String description;
        String type;
        String function;
        String applicationDomain;
        String classification;
        Identification ident = LibraryElementFactory.eINSTANCE.createIdentification();
        String standard = this.getAttributeValue("Standard");
        if (standard != null) {
            ident.setStandard(standard);
        }
        if ((classification = this.getAttributeValue("Classification")) != null) {
            ident.setClassification(classification);
        }
        if ((applicationDomain = this.getAttributeValue("ApplicationDomain")) != null) {
            ident.setApplicationDomain(applicationDomain);
        }
        if ((function = this.getAttributeValue("Function")) != null) {
            ident.setFunction(function);
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            ident.setType(type);
        }
        if ((description = this.getAttributeValue("Description")) != null) {
            ident.setDescription(description);
        }
        elem.setIdentification(ident);
        this.proceedToEndElementNamed("Identification");
    }

    protected void parseVersionInfo(LibraryElement elem) throws TypeImportException, XMLStreamException {
        String remarks;
        String version;
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        String organization = this.getReader().getAttributeValue("", "Organization");
        if (organization != null) {
            versionInfo.setOrganization(organization);
        }
        if ((version = this.getReader().getAttributeValue("", "Version")) == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingVersionInfo);
        }
        versionInfo.setVersion(version);
        String author = this.getReader().getAttributeValue("", "Author");
        if (author == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingAuthorInfo);
        }
        versionInfo.setAuthor(author);
        String date = this.getReader().getAttributeValue("", "Date");
        if (date != null) {
            versionInfo.setDate(date);
        }
        versionInfo.setRemarks((remarks = this.getReader().getAttributeValue("", "Remarks")) != null ? remarks : "");
        elem.getVersionInfo().add((Object)versionInfo);
        this.proceedToEndElementNamed("VersionInfo");
    }

    public void getXandY(PositionableElement positionableElement) throws TypeImportException {
        try {
            String y;
            String x = this.getAttributeValue("x");
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            if (x != null) {
                pos.setX(CoordinateConverter.INSTANCE.convertFrom1499XML(x));
            }
            if ((y = this.getAttributeValue("y")) != null) {
                pos.setY(CoordinateConverter.INSTANCE.convertFrom1499XML(y));
            }
            positionableElement.setPosition(pos);
        }
        catch (NumberFormatException nfe) {
            throw new TypeImportException(Messages.FBTImporter_POSITION_EXCEPTION, nfe);
        }
    }

    protected void readNameCommentAttributes(INamedElement namedElement) throws TypeImportException {
        this.readNameAttribute(namedElement);
        this.readCommentAttribute(namedElement);
    }

    private void readNameAttribute(INamedElement namedElement) throws TypeImportException {
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.Import_ERROR_NameNotDefined);
        }
        namedElement.setName(name.trim());
    }

    private void readCommentAttribute(INamedElement namedElement) {
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            namedElement.setComment(comment);
        }
    }

    protected void parseGenericAttributeNode(ConfigurableObject confObject) {
        String name = this.getAttributeValue("Name");
        String type = this.getAttributeValue("Type");
        String value = this.getAttributeValue("Value");
        String comment = this.getAttributeValue("Comment");
        if (name != null && value != null) {
            confObject.setAttribute(name, type == null ? "STRING" : type, value, comment);
        }
        if (confObject instanceof StructManipulator) {
            this.checkStructAttribute((StructManipulator)confObject, name);
        }
    }

    private void checkStructAttribute(StructManipulator fb, String name) {
        if ("StructuredType".equals(name)) {
            Attribute attr = fb.getAttribute("StructuredType");
            StructuredType structType = this.getTypeLibrary().getDataTypeLibrary().getStructuredType(attr.getValue());
            fb.setStructTypeElementsAtInterface(structType);
        } else if ("VisibleChildren".equals(name)) {
            fb.setStructTypeElementsAtInterface(fb.getStructType());
        }
    }

    protected VarDeclaration parseParameter() throws TypeImportException, XMLStreamException {
        VarDeclaration variable = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterNotSet);
        }
        variable.setName(name);
        String value = this.getAttributeValue("Value");
        if (value == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterValueNotSet);
        }
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue(value);
        variable.setValue(val);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            variable.setComment(comment);
        }
        this.proceedToEndElementNamed("Parameter");
        return variable;
    }

    protected String getAttributeValue(String attributeName) {
        return this.getReader().getAttributeValue("", attributeName);
    }

    protected CompilerInfo parseCompilerInfo() throws TypeImportException, XMLStreamException {
        String classdef;
        CompilerInfo compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
        String header = this.getAttributeValue("header");
        if (header != null) {
            compilerInfo.setHeader(header);
        }
        if ((classdef = this.getAttributeValue("classdef")) != null) {
            compilerInfo.setClassdef(classdef);
        }
        this.processChildren("CompilerInfo", name -> {
            if ("Compiler".equals(name)) {
                this.parseCompiler(compilerInfo);
                return true;
            }
            return false;
        });
        return compilerInfo;
    }

    private void parseCompiler(CompilerInfo compilerInfo) throws TypeImportException, XMLStreamException {
        String vendor;
        Compiler comp;
        block19: {
            comp = LibraryElementFactory.eINSTANCE.createCompiler();
            String language = this.getAttributeValue("Language");
            if (language == null) break block19;
            switch (language.toUpperCase()) {
                case "C": {
                    comp.setLanguage(Language.C);
                    break;
                }
                case "CPP": {
                    comp.setLanguage(Language.CPP);
                    break;
                }
                case "JAVA": {
                    comp.setLanguage(Language.JAVA);
                    break;
                }
                case "OTHER": {
                    comp.setLanguage(Language.OTHER);
                    break;
                }
                default: {
                    throw new TypeImportException(Messages.CompilableElementImporter_ERROR_UnsupportedLanguage);
                }
            }
        }
        if ((vendor = this.getAttributeValue("Vendor")) == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VendorNotSet);
        }
        comp.setVendor(vendor);
        String product = this.getAttributeValue("Product");
        if (product == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_ProductNotSet);
        }
        comp.setProduct(product);
        String version = this.getAttributeValue("Version");
        if (version == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VersionNotSet);
        }
        comp.setVersion(version);
        this.proceedToEndElementNamed("Compiler");
        compilerInfo.getCompiler().add((Object)comp);
    }

    protected void parseFBChildren(FBNetworkElement block, String parentNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(parentNodeName, name -> {
            switch (name) {
                case "Parameter": {
                    this.parseParameter(block);
                    return true;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(block);
                    this.proceedToEndElementNamed("Attribute");
                    return true;
                }
            }
            return false;
        });
    }

    protected void parseParameter(FBNetworkElement block) throws TypeImportException, XMLStreamException {
        VarDeclaration parameter = this.parseParameter();
        VarDeclaration vInput = CommonElementImporter.getVarNamed(block.getInterface(), parameter.getName(), true);
        if (vInput != null) {
            vInput.setValue(parameter.getValue());
            this.validateValue(vInput);
        }
    }

    protected void validateValue(VarDeclaration vInput) {
        String validation = ValueValidator.validateValue(vInput.getType(), vInput.getValue().getValue());
        if (validation != null && !validation.trim().isEmpty()) {
            ErrorMarkerBuilder e = FordiacMarkerHelper.createValueErrorMarkerBuilder(validation, vInput.getValue(), this.getLineNumber());
            this.errorMarkerAttributes.add(e);
        }
    }

    protected boolean isProfileAttribute() {
        String name = this.getAttributeValue("Name");
        return name != null && "Profile".equals(name);
    }

    protected void parseProfile(Device device) {
        String value = this.getAttributeValue("Value");
        if (value != null) {
            device.setProfile(value);
        }
    }

    protected Resource parseResource() throws TypeImportException, XMLStreamException {
        Resource resource = LibraryElementFactory.eINSTANCE.createResource();
        resource.setDeviceTypeResource(false);
        this.readNameCommentAttributes(resource);
        this.parseResourceType(resource);
        FBNetwork fbNetwork = CommonElementImporter.createResourceTypeNetwork(resource);
        resource.setFBNetwork(fbNetwork);
        this.processChildren("Resource", name -> {
            switch (name) {
                case "FBNetwork": {
                    new ResDevFBNetworkImporter(this, fbNetwork, (EList<VarDeclaration>)resource.getVarDeclarations()).parseFBNetwork("FBNetwork");
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(resource);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = CommonElementImporter.getParamter((EList<VarDeclaration>)resource.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    resource.getVarDeclarations().add((Object)parameter);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return resource;
    }

    private void parseResourceType(Resource resource) {
        ResourceTypeEntry entry;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && (entry = this.getPalette().getResourceTypeEntry(typeName)) != null) {
            resource.setPaletteEntry(entry);
            CommonElementImporter.createParamters(resource);
        }
    }

    public static void createParamters(IVarElement element) {
        if (element instanceof Device) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((DeviceTypePaletteEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getDeviceType().getVarDeclaration()));
        }
        if (element instanceof Resource) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((ResourceTypeEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getResourceType().getVarDeclaration()));
        }
        for (VarDeclaration varDecl : element.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            varDecl.setValue(value);
            VarDeclaration typeVar = CommonElementImporter.getTypeVariable(varDecl);
            if (typeVar == null || typeVar.getValue() == null) continue;
            value.setValue(typeVar.getValue().getValue());
        }
    }

    private static VarDeclaration getTypeVariable(VarDeclaration variable) {
        Resource res;
        EList<VarDeclaration> varList = null;
        if (variable.eContainer() instanceof Device) {
            Device dev = (Device)variable.eContainer();
            if (dev.getType() != null) {
                varList = dev.getType().getVarDeclaration();
            }
        } else if (variable.eContainer() instanceof Resource && (res = (Resource)variable.eContainer()).getType() != null) {
            varList = res.getType().getVarDeclaration();
        }
        if (varList != null) {
            return CommonElementImporter.getParamter(varList, variable.getName());
        }
        return null;
    }

    protected static VarDeclaration getParamter(EList<VarDeclaration> paramList, String name) {
        for (VarDeclaration varDecl : paramList) {
            if (!varDecl.getName().equals(name)) continue;
            return varDecl;
        }
        return null;
    }

    private static FBNetwork createResourceTypeNetwork(Resource resource) {
        FBNetwork resourceFBNetwork = null;
        if (resource.getType() != null && resource.getType().getFBNetwork() != null) {
            InterfaceList il = LibraryElementFactory.eINSTANCE.createInterfaceList();
            il.getInputVars().addAll((Collection)resource.getVarDeclarations());
            resourceFBNetwork = FBNetworkHelper.createResourceFBNetwork(resource.getType().getFBNetwork(), il);
            resource.getVarDeclarations().addAll(il.getInputVars());
        } else {
            resourceFBNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        }
        return resourceFBNetwork;
    }

    protected static interface IChildHandler {
        public boolean checkChild(String var1) throws XMLStreamException, TypeImportException;
    }

    private static class ImporterStreams
    implements AutoCloseable {
        private final InputStream inputStream;
        private final XMLStreamReader reader;

        public ImporterStreams(InputStream inputStream, XMLStreamReader reader) {
            this.inputStream = inputStream;
            this.reader = reader;
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
            this.inputStream.close();
        }
    }
}

