/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.DataTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.DataTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class AbstractTypeExporter
extends CommonElementExporter {
    private final LibraryElement type;

    protected AbstractTypeExporter(LibraryElement type) {
        this.type = type;
    }

    protected AbstractTypeExporter(CommonElementExporter parent) {
        super(parent);
        this.type = null;
    }

    protected LibraryElement getType() {
        return this.type;
    }

    protected void createXMLEntries() throws XMLStreamException {
        this.createNamedElementEntry(this.getType(), this.getRootTag());
        this.addIdentification(this.getType());
        this.addVersionInfo(this.getType());
        this.createTypeSpecificXMLEntries();
        this.addEndElement();
    }

    public static void saveType(final PaletteEntry entry) {
        final AbstractTypeExporter exporter = AbstractTypeExporter.getTypeExporter(entry);
        if (exporter != null) {
            try {
                exporter.createXMLEntries();
            }
            catch (XMLStreamException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            WorkspaceJob job = new WorkspaceJob("Save type file: " + entry.getFile().getName()){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    exporter.writeToFile(entry.getFile());
                    entry.setLastModificationTimestamp(entry.getFile().getModificationStamp());
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)entry.getFile().getParent());
            job.schedule();
        }
    }

    private static AbstractTypeExporter getTypeExporter(PaletteEntry entry) {
        if (entry instanceof FBTypePaletteEntry) {
            return new FbtExporter((FBTypePaletteEntry)entry);
        }
        if (entry instanceof AdapterTypePaletteEntry) {
            return new AdapterExporter((AdapterTypePaletteEntry)entry);
        }
        if (entry instanceof SubApplicationTypePaletteEntry) {
            return new SubApplicationTypeExporter((SubApplicationTypePaletteEntry)entry);
        }
        if (entry instanceof DataTypePaletteEntry) {
            return new DataTypeExporter((AnyDerivedType)entry.getType());
        }
        return null;
    }

    protected abstract String getRootTag();

    protected abstract void createTypeSpecificXMLEntries() throws XMLStreamException;

    protected void addCompilerInfo(CompilerInfo compilerInfo) throws XMLStreamException {
        if (compilerInfo != null) {
            this.addStartElement("CompilerInfo");
            if (compilerInfo.getHeader() != null && !"".equals(compilerInfo.getHeader())) {
                this.getWriter().writeAttribute("header", compilerInfo.getHeader());
            }
            if (compilerInfo.getClassdef() != null && !"".equals(compilerInfo.getClassdef())) {
                this.getWriter().writeAttribute("classdef", compilerInfo.getClassdef());
            }
            for (Compiler compiler : compilerInfo.getCompiler()) {
                this.addCompiler(compiler);
            }
            this.addEndElement();
        }
    }

    private void addCompiler(Compiler compiler) throws XMLStreamException {
        this.addEmptyStartElement("Compiler");
        this.getWriter().writeAttribute("Language", compiler.getLanguage() != null ? compiler.getLanguage().getName() : "");
        this.getWriter().writeAttribute("Vendor", compiler.getVendor() != null ? compiler.getVendor() : "");
        this.getWriter().writeAttribute("Product", compiler.getProduct() != null ? compiler.getProduct() : "");
        this.getWriter().writeAttribute("Version", compiler.getVersion() != null ? compiler.getVersion() : "");
    }

    protected void addVarDeclaration(VarDeclaration varDecl) throws XMLStreamException {
        boolean hasAttributes;
        boolean bl = hasAttributes = !varDecl.getAttributes().isEmpty();
        if (hasAttributes) {
            this.addStartElement("VarDeclaration");
        } else {
            this.addEmptyStartElement("VarDeclaration");
        }
        this.addNameTypeCommentAttribute(varDecl, varDecl.getType());
        if (varDecl.isArray()) {
            this.getWriter().writeAttribute("ArraySize", Integer.toString(varDecl.getArraySize()));
        }
        if (varDecl.getValue() != null && !varDecl.getValue().getValue().isEmpty()) {
            this.getWriter().writeAttribute("InitialValue", varDecl.getValue().getValue());
        }
        if (hasAttributes) {
            this.addAttributes(varDecl.getAttributes());
            this.addEndElement();
        }
    }
}

