/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public abstract class AbstractBlockTypeExporter
extends AbstractTypeExporter {
    protected AbstractBlockTypeExporter(FBType type) {
        super(type);
    }

    protected AbstractBlockTypeExporter(CommonElementExporter parent) {
        super(parent);
    }

    @Override
    protected FBType getType() {
        return (FBType)super.getType();
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        this.addInterfaceList(this.getType().getInterfaceList());
        this.createBlockTypeSpecificXMLEntries();
        this.addService(this.getType());
    }

    protected abstract void createBlockTypeSpecificXMLEntries() throws XMLStreamException;

    protected void addInterfaceList(InterfaceList interfaceList) throws XMLStreamException {
        this.addStartElement(this.getInterfaceListElementName());
        this.addEventList((List<Event>)interfaceList.getEventInputs(), this.getEventInputsElementName());
        this.addEventList((List<Event>)interfaceList.getEventOutputs(), this.getEventOutputsElementName());
        this.addVarList((List<VarDeclaration>)interfaceList.getInputVars(), "InputVars");
        this.addVarList((List<VarDeclaration>)interfaceList.getOutputVars(), "OutputVars");
        this.createAdapterList((List<AdapterDeclaration>)interfaceList.getPlugs(), "Plugs");
        this.createAdapterList((List<AdapterDeclaration>)interfaceList.getSockets(), "Sockets");
        this.addEndElement();
    }

    protected String getInterfaceListElementName() {
        return "InterfaceList";
    }

    private void createAdapterList(List<AdapterDeclaration> adapterList, String elementName) throws XMLStreamException {
        if (!adapterList.isEmpty()) {
            this.addStartElement(elementName);
            for (AdapterDeclaration adapter : adapterList) {
                this.addAdapterDeclaration(adapter);
            }
            this.addEndElement();
        }
    }

    private void addAdapterDeclaration(AdapterDeclaration adapterDecl) throws XMLStreamException {
        boolean hasAttributes;
        boolean bl = hasAttributes = !adapterDecl.getAttributes().isEmpty();
        if (hasAttributes) {
            this.addStartElement("AdapterDeclaration");
        } else {
            this.addEmptyStartElement("AdapterDeclaration");
        }
        this.addNameTypeCommentAttribute(adapterDecl, adapterDecl.getType());
        if (adapterDecl.getAdapterFB() != null) {
            this.addXYAttributes(adapterDecl.getAdapterFB());
        }
        if (hasAttributes) {
            this.addAttributes(adapterDecl.getAttributes());
            this.addEndElement();
        }
    }

    protected void addVarList(List<VarDeclaration> varList, String elementName) throws XMLStreamException {
        if (!varList.isEmpty()) {
            this.addStartElement(elementName);
            for (VarDeclaration varDecl : varList) {
                if (varDecl instanceof AdapterDeclaration) continue;
                this.addVarDeclaration(varDecl);
            }
            this.addEndElement();
        }
    }

    protected void addInternalVarList(List<VarDeclaration> varList, List<FB> fbList, String elementName) throws XMLStreamException {
        if (!varList.isEmpty() || !fbList.isEmpty()) {
            this.addStartElement(elementName);
            for (VarDeclaration varDecl : varList) {
                if (varDecl instanceof AdapterDeclaration) continue;
                this.addVarDeclaration(varDecl);
            }
            for (FB fb : fbList) {
                this.addStartElement("FB");
                this.addNameAttribute(fb.getName());
                if (fb.getType() != null) {
                    this.addTypeAttribute(fb.getType());
                }
                this.addCommentAttribute(fb);
                this.addAttributes(fb.getAttributes());
                this.addEndElement();
            }
            this.addEndElement();
        }
    }

    private void addEventList(List<Event> eventList, String elementName) throws XMLStreamException {
        if (!eventList.isEmpty()) {
            this.addStartElement(elementName);
            for (Event event : eventList) {
                this.addEvent(event);
            }
            this.addEndElement();
        }
    }

    protected String getEventOutputsElementName() {
        return "EventOutputs";
    }

    protected String getEventInputsElementName() {
        return "EventInputs";
    }

    private void addEvent(Event event) throws XMLStreamException {
        this.addStartElement(this.getEventElementName());
        this.addNameAttribute(event.getName());
        this.getWriter().writeAttribute("Type", "Event");
        this.addCommentAttribute(event);
        this.addWith(event);
        this.addAttributes(event.getAttributes());
        this.addEndElement();
    }

    protected String getEventElementName() {
        return "Event";
    }

    private void addWith(Event event) throws XMLStreamException {
        for (With with : event.getWith()) {
            this.addEmptyStartElement("With");
            VarDeclaration varDecl = with.getVariables();
            this.getWriter().writeAttribute("Var", varDecl.getName() != null ? varDecl.getName() : "");
        }
    }

    private void addService(FBType sfb) throws XMLStreamException {
        if (sfb.getService() != null && sfb.getService().getRightInterface() != null && sfb.getService().getLeftInterface() != null) {
            this.addStartElement("Service");
            this.getWriter().writeAttribute("RightInterface", sfb.getService().getRightInterface().getName());
            this.getWriter().writeAttribute("LeftInterface", sfb.getService().getLeftInterface().getName());
            this.addCommentAttribute(sfb);
            this.addServiceSequences((List<ServiceSequence>)sfb.getService().getServiceSequence());
            this.addEndElement();
        }
    }

    private void addServiceSequences(List<ServiceSequence> sequences) throws XMLStreamException {
        for (ServiceSequence seq : sequences) {
            this.addStartElement("ServiceSequence");
            this.addNameAttribute(seq.getName());
            this.addCommentAttribute(seq);
            this.addServiceTransactions((List<ServiceTransaction>)seq.getServiceTransaction());
            this.addEndElement();
        }
    }

    private void addServiceTransactions(List<ServiceTransaction> transactions) throws XMLStreamException {
        for (ServiceTransaction transaction : transactions) {
            this.addStartElement("ServiceTransaction");
            if (transaction.getInputPrimitive() != null) {
                this.addPrimitive(transaction.getInputPrimitive(), "InputPrimitive");
            }
            if (!transaction.getOutputPrimitive().isEmpty()) {
                this.addOutputPrimitives(transaction);
            }
            this.addEndElement();
        }
    }

    private void addPrimitive(Primitive prim, String primNodeName) throws XMLStreamException {
        this.addEmptyStartElement(primNodeName);
        this.getWriter().writeAttribute("Interface", prim.getInterface() != null && prim.getInterface().getName() != null ? prim.getInterface().getName() : "");
        this.getWriter().writeAttribute("Event", prim.getEvent() != null ? prim.getEvent() : "");
        if (prim.getParameters() != null && !prim.getParameters().equals(" ")) {
            this.getWriter().writeAttribute("Parameters", prim.getParameters());
        }
    }

    private void addOutputPrimitives(ServiceTransaction transaction) throws XMLStreamException {
        for (OutputPrimitive primitive : transaction.getOutputPrimitive()) {
            this.addPrimitive(primitive, "OutputPrimitive");
        }
    }
}

