/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceConstants;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class SequenceFigure
extends Layer {
    private static final String TRIANGLE_RIGHTWARDS = "\u25b8  ";
    private static final String TRIANGLE_DOWNWARDS = "\u25be  ";
    private final Label nameLabel = new Label();
    private final Label commentLabel = new Label();
    private String name;
    private String comment;
    private final IFigure titleBar;
    private final Layer transactionContainer = new Layer();
    private boolean isExpanded;

    public SequenceFigure(boolean isExpanded) {
        this.titleBar = new Figure();
        this.setExpanded(isExpanded);
        this.createVisuals();
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
        this.setLabelText(this.name, this.comment);
    }

    private void createVisuals() {
        FlowLayout sequenceLayout = new FlowLayout();
        this.setLayoutManager((LayoutManager)sequenceLayout);
        this.titleBar.setLayoutManager((LayoutManager)new GridLayout(2, true));
        this.titleBar.setBackgroundColor(ColorManager.getColor((RGB)ServiceConstants.LIGHT_GRAY));
        this.titleBar.setOpaque(true);
        MarginBorder titleBorder = new MarginBorder(new Insets(10, 20, 3, 0));
        this.nameLabel.setBorder((Border)titleBorder);
        this.nameLabel.setForegroundColor(ColorManager.getColor((RGB)ServiceConstants.TEXT_BLUE));
        this.nameLabel.setFont(new Font((Device)Display.getDefault(), "Arial", 10, 1));
        this.nameLabel.setLabelAlignment(1);
        this.commentLabel.setOpaque(true);
        this.commentLabel.setLabelAlignment(4);
        this.commentLabel.setForegroundColor(ColorConstants.black);
        GridData nameLayoutData = new GridData(16384, 4, true, true);
        this.titleBar.getLayoutManager().setConstraint((IFigure)this.nameLabel, (Object)nameLayoutData);
        GridData commentLayoutData = new GridData(131072, 4, true, true);
        this.titleBar.getLayoutManager().setConstraint((IFigure)this.commentLabel, (Object)commentLayoutData);
        this.titleBar.add((IFigure)this.nameLabel);
        this.titleBar.add((IFigure)this.commentLabel);
        this.add(this.titleBar);
        this.setConstraint(this.titleBar, new GridData(4, 4, true, true));
        FlowLayout containerLayout = new FlowLayout();
        this.transactionContainer.setLayoutManager((LayoutManager)containerLayout);
        this.add((IFigure)this.transactionContainer);
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public Label getCommentLabel() {
        return this.commentLabel;
    }

    public void setLabelText(String name, String comment) {
        String sequenceName;
        this.name = sequenceName = name != null ? name : "";
        String symbol = this.isExpanded ? TRIANGLE_DOWNWARDS : TRIANGLE_RIGHTWARDS;
        this.nameLabel.setText(String.valueOf(symbol) + sequenceName);
        String serviceComment = comment != null ? comment : "";
        this.comment = comment;
        this.commentLabel.setText(serviceComment);
        this.commentLabel.setToolTip((IFigure)new Label(serviceComment));
    }

    public Layer getTransactionContainer() {
        return this.transactionContainer;
    }
}

