/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.SequenceFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.TransactionLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.policies.HighlightEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;

public class ServiceSequenceEditPart
extends AbstractDirectEditableEditPart {
    private boolean isExpanded = true;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ServiceSequenceEditPart.this.refresh();
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.getModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteServiceSequenceCommand(ServiceSequenceEditPart.this.getModel().getService().getFBType(), ServiceSequenceEditPart.this.getModel());
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TransactionLayoutEditPolicy());
    }

    public void toggleExpanded() {
        this.isExpanded = !this.isExpanded;
        this.refresh();
        this.getFigure().setExpanded(this.isExpanded);
    }

    public SequenceFigure getFigure() {
        return (SequenceFigure)super.getFigure();
    }

    public ServiceSequence getModel() {
        return (ServiceSequence)super.getModel();
    }

    protected IFigure createFigure() {
        SequenceFigure figure = new SequenceFigure(this.isExpanded);
        figure.setBorder((Border)new MarginBorder(new Insets(12, 0, 0, 0)));
        GridData layoutData = new GridData(4, 0, true, false);
        figure.getLayoutManager().setConstraint((IFigure)figure, (Object)layoutData);
        return figure;
    }

    protected List<ServiceTransaction> getModelChildren() {
        if (this.isExpanded) {
            return new ArrayList<ServiceTransaction>((Collection<ServiceTransaction>)this.getModel().getServiceTransaction());
        }
        return Collections.emptyList();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof TransactionEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            this.getFigure().getTransactionContainer().add(child, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof TransactionEditPart) {
            this.getFigure().getTransactionContainer().remove(child);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        SequenceFigure figure = this.getFigure();
        if (this.getModel() != null) {
            figure.setLabelText(this.getModel().getName(), this.getModel().getComment());
        }
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected DirectEditManager createDirectEditManager() {
        DirectEditManager dem = super.createDirectEditManager();
        LabelCellEditorLocator locator = new LabelCellEditorLocator(this.getFigure().getNameLabel(), this.getZoomManager(), (FigureCanvas)this.getViewer().getControl());
        dem.setLocator((CellEditorLocator)locator);
        return dem;
    }

    private ZoomManager getZoomManager() {
        return ((ZoomScalableFreeformRootEditPart)this.getRoot()).getZoomManager();
    }

    public Label getNameLabel() {
        return new Label(this.getModel().getName());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = !isExpanded;
        this.refresh();
    }
}

