/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.AbstractCreateElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;

public class CreateServiceSequenceCommand
extends AbstractCreateElementCommand<ServiceSequence> {
    private final FBType fbType;
    private boolean emptyService;
    private static final String LEFT_INTERFACE_NAME = "left interface";
    private static final String RIGHT_INTERFACE_NAME = "right interface";
    private static final String DEFAULT_SEQUENCE_NAME = "Service Sequence";
    private ServiceInterface leftInterface;
    private ServiceInterface rightInterface;

    public CreateServiceSequenceCommand(Service service) {
        super(service.getServiceSequence());
        this.fbType = service.getFBType();
    }

    public CreateServiceSequenceCommand(Service service, ServiceSequence refElement) {
        super(service.getServiceSequence(), refElement);
        this.fbType = service.getFBType();
    }

    @Override
    protected ServiceSequence createNewElement() {
        ServiceSequence seq = LibraryElementFactory.eINSTANCE.createServiceSequence();
        seq.setName(DEFAULT_SEQUENCE_NAME);
        return seq;
    }

    private void createEmptyServiceModel() {
        if (this.fbType.getService() == null) {
            this.emptyService = true;
            this.fbType.setService(LibraryElementFactory.eINSTANCE.createService());
        }
        if (this.fbType.getService().getLeftInterface() == null) {
            this.leftInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.leftInterface.setName(LEFT_INTERFACE_NAME);
            this.fbType.getService().setLeftInterface(this.leftInterface);
        }
        if (this.fbType.getService().getRightInterface() == null) {
            this.rightInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.rightInterface.setName(RIGHT_INTERFACE_NAME);
            this.fbType.getService().setRightInterface(this.rightInterface);
        }
    }

    @Override
    public void execute() {
        this.createEmptyServiceModel();
        super.execute();
    }

    @Override
    public void undo() {
        if (this.leftInterface != null) {
            this.fbType.getService().setLeftInterface(null);
        }
        if (this.rightInterface != null) {
            this.fbType.getService().setRightInterface(null);
        }
        if (this.emptyService) {
            this.fbType.setService(null);
        }
        super.undo();
    }

    @Override
    public void redo() {
        this.createEmptyServiceModel();
        super.redo();
    }
}

