/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.commands.Command;

public abstract class AbstractCreateElementCommand<T>
extends Command
implements CreationCommand {
    private T newElement;
    private final EList<T> list;
    private int index;

    protected AbstractCreateElementCommand(EList<T> list) {
        this.list = list;
        this.calculateInsertionIndex(list, null);
    }

    protected AbstractCreateElementCommand(EList<T> list, int index) {
        this(list);
        this.index = index;
    }

    protected AbstractCreateElementCommand(EList<T> list, T refElement) {
        this(list);
        this.calculateInsertionIndex(list, refElement);
    }

    private void calculateInsertionIndex(EList<T> list, T refElement) {
        this.index = refElement != null ? list.indexOf(refElement) + 1 : list.size();
    }

    public boolean canExecute() {
        return this.list != null;
    }

    public void execute() {
        this.newElement = this.createNewElement();
        this.list.add(this.index, this.newElement);
    }

    protected abstract T createNewElement();

    public void undo() {
        this.list.remove(this.newElement);
    }

    public void redo() {
        this.list.add(this.index, this.newElement);
    }

    public Object getCreatedElement() {
        return this.newElement;
    }
}

